/*
 * Decompiled with CFR 0.152.
 */
package com.github.jinahya.bit.io;

import com.github.jinahya.bit.io.BitInput;
import com.github.jinahya.bit.io.BitIoConstraints;
import com.github.jinahya.bit.io.BitReadable;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;

public class ExtendedBitInput {
    public static <T extends BitReadable> T readObject(BitInput input, Class<T> type) throws IOException {
        if (input == null) {
            throw new NullPointerException("input is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            if (!constructor.isSynthetic()) {
                constructor.setAccessible(true);
            }
            try {
                BitReadable value = (BitReadable)constructor.newInstance(new Object[0]);
                value.read(input);
                return (T)value;
            }
            catch (IllegalAccessException iae) {
                throw new RuntimeException(iae);
            }
            catch (InstantiationException ie) {
                throw new RuntimeException(ie);
            }
            catch (InvocationTargetException ite) {
                throw new RuntimeException(ite);
            }
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
    }

    public static byte[] readBytes(BitInput bitInput, int lengthSize, boolean byteUnsigned, int byteSize) throws IOException {
        if (bitInput == null) {
            throw new NullPointerException("bitInput is null");
        }
        BitIoConstraints.requireValidSizeInt(true, lengthSize);
        BitIoConstraints.requireValidSizeByte(byteUnsigned, byteSize);
        int length = bitInput.readInt(true, lengthSize);
        byte[] byteArray = new byte[length];
        for (int i = 0; i < byteArray.length; ++i) {
            byteArray[i] = bitInput.readByte(byteUnsigned, byteSize);
        }
        return byteArray;
    }

    public static byte[] readBytes(BitInput bitInput, int lengthSize, int byteSize) throws IOException {
        return ExtendedBitInput.readBytes(bitInput, lengthSize, false, byteSize);
    }

    public static String readString(BitInput bitInput, int lengthSize, int byteSize, String charsetName) throws IOException {
        return new String(ExtendedBitInput.readBytes(bitInput, lengthSize, byteSize), charsetName);
    }

    public static String readString(BitInput bitInput, int lengthSize, int byteSize, Charset charset) throws IOException {
        return new String(ExtendedBitInput.readBytes(bitInput, lengthSize, byteSize), charset);
    }

    public static String readAscii(BitInput bitInput, int lengthSize) throws IOException {
        return new String(ExtendedBitInput.readBytes(bitInput, lengthSize, true, 7), "ASCII");
    }

    protected ExtendedBitInput() {
    }
}

