/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.properties;

import java.util.HashMap;
import java.util.Map;
import org.datanucleus.properties.FrequentlyAccessedProperties;
import org.datanucleus.properties.PropertyTypeInvalidException;

public abstract class PropertyStore {
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected FrequentlyAccessedProperties frequentProperties = new FrequentlyAccessedProperties();

    protected void setPropertyInternal(String name, Object value) {
        this.properties.put(name.toLowerCase(), value);
        this.frequentProperties.setProperty(name.toLowerCase(), value);
    }

    public Object getProperty(String name) {
        if (this.properties.containsKey(name)) {
            return this.properties.get(name);
        }
        return null;
    }

    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    public boolean hasPropertyNotNull(String name) {
        return this.getProperty(name) != null;
    }

    public int getIntProperty(String name) {
        Object obj = this.getProperty(name);
        if (obj != null) {
            if (obj instanceof Number) {
                return ((Number)obj).intValue();
            }
            if (obj instanceof String) {
                Integer intVal = Integer.valueOf((String)obj);
                this.setPropertyInternal(name, intVal);
                return intVal;
            }
        } else {
            return 0;
        }
        throw new PropertyTypeInvalidException(name, "int");
    }

    public boolean getBooleanProperty(String name) {
        return this.getBooleanProperty(name, false);
    }

    public boolean getBooleanProperty(String name, boolean resultIfNotSet) {
        Object obj = this.getProperty(name);
        if (obj != null) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof String) {
                Boolean boolVal = Boolean.valueOf((String)obj);
                this.setPropertyInternal(name, boolVal);
                return boolVal;
            }
        } else {
            return resultIfNotSet;
        }
        throw new PropertyTypeInvalidException(name, "boolean");
    }

    public Boolean getBooleanObjectProperty(String name) {
        Object obj = this.getProperty(name);
        if (obj != null) {
            if (obj instanceof Boolean) {
                return (Boolean)obj;
            }
            if (obj instanceof String) {
                Boolean boolVal = Boolean.valueOf((String)obj);
                this.setPropertyInternal(name, boolVal);
                return boolVal;
            }
        } else {
            return null;
        }
        throw new PropertyTypeInvalidException(name, "Boolean");
    }

    public String getStringProperty(String name) {
        Object obj = this.getProperty(name);
        if (obj != null) {
            if (obj instanceof String) {
                return (String)obj;
            }
        } else {
            return null;
        }
        throw new PropertyTypeInvalidException(name, "String");
    }

    public FrequentlyAccessedProperties getFrequentProperties() {
        return this.frequentProperties;
    }
}

