/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.misc.conf;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ddl.DDLOperation;
import org.apache.hadoop.hive.ql.ddl.DDLOperationContext;
import org.apache.hadoop.hive.ql.ddl.ShowUtils;
import org.apache.hadoop.hive.ql.ddl.misc.conf.ShowConfDesc;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class ShowConfOperation
extends DDLOperation<ShowConfDesc> {
    public ShowConfOperation(DDLOperationContext context, ShowConfDesc desc) {
        super(context, desc);
    }

    @Override
    public int execute() throws HiveException, IOException {
        HiveConf.ConfVars conf = HiveConf.getConfVars((String)((ShowConfDesc)this.desc).getConfName());
        if (conf == null) {
            throw new HiveException("invalid configuration name " + ((ShowConfDesc)this.desc).getConfName());
        }
        String description = conf.getDescription();
        String defaultValue = conf.getDefaultValue();
        try (DataOutputStream output = ShowUtils.getOutputStream(((ShowConfDesc)this.desc).getResFile(), this.context);){
            if (defaultValue != null) {
                output.write(defaultValue.getBytes(StandardCharsets.UTF_8));
            }
            output.write(9);
            output.write(conf.typeString().getBytes(StandardCharsets.UTF_8));
            output.write(9);
            if (description != null) {
                output.write(description.replaceAll(" *\n *", " ").getBytes(StandardCharsets.UTF_8));
            }
            output.write(10);
        }
        return 0;
    }
}

