/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.ddl.process.show.compactions;

import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.EnumUtils;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.ddl.DDLSemanticAnalyzerFactory;
import org.apache.hadoop.hive.ql.ddl.DDLWork;
import org.apache.hadoop.hive.ql.ddl.process.show.compactions.ShowCompactionsDesc;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.PTFInvocationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;

@DDLSemanticAnalyzerFactory.DDLType(types={1219})
public class ShowCompactionsAnalyzer
extends BaseSemanticAnalyzer {
    public ShowCompactionsAnalyzer(QueryState queryState) throws SemanticException {
        super(queryState);
    }

    @Override
    public void analyzeInternal(ASTNode root) throws SemanticException {
        this.ctx.setResFile(this.ctx.getLocalTmpPath());
        String dbName = null;
        String tblName = null;
        String poolName = null;
        String compactionType = null;
        String compactionStatus = null;
        long compactionId = 0L;
        String orderBy = null;
        short limit = -1;
        Map<String, String> partitionSpec = null;
        if (root.getChildCount() > 6) {
            throw new SemanticException(ErrorMsg.INVALID_AST_TREE.getMsg(root.toStringTree()));
        }
        block9: for (int i = 0; i < root.getChildCount(); ++i) {
            ASTNode child = (ASTNode)root.getChild(i);
            switch (child.getType()) {
                case 1284: {
                    tblName = child.getChild(0).getText();
                    if (child.getChild(0).getChildCount() == 2) {
                        dbName = child.getChild(0).getChild(0).getText();
                        tblName = child.getChild(0).getChild(1).getText();
                    }
                    if (child.getChildCount() != 2) continue block9;
                    ASTNode partitionSpecNode = (ASTNode)child.getChild(1);
                    partitionSpec = ShowCompactionsAnalyzer.getValidatedPartSpec(this.getTable(dbName, tblName, true), partitionSpecNode, this.conf, false);
                    continue block9;
                }
                case 953: {
                    poolName = ShowCompactionsAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block9;
                }
                case 951: {
                    compactionType = ShowCompactionsAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block9;
                }
                case 950: {
                    compactionStatus = ShowCompactionsAnalyzer.unescapeSQLString(child.getChild(0).getText());
                    continue block9;
                }
                case 952: {
                    compactionId = Long.parseLong(child.getChild(0).getText());
                    continue block9;
                }
                case 1088: {
                    limit = Short.valueOf(child.getChild(0).getText());
                    continue block9;
                }
                case 1130: {
                    orderBy = this.processSortOrderSpec(child);
                    continue block9;
                }
                default: {
                    dbName = ShowCompactionsAnalyzer.stripQuotes(child.getText());
                }
            }
        }
        ShowCompactionsDesc desc = new ShowCompactionsDesc(this.ctx.getResFile(), compactionId, dbName, tblName, poolName, compactionType, compactionStatus, partitionSpec, limit, orderBy);
        Task<DDLWork> task = TaskFactory.get(new DDLWork(this.getInputs(), this.getOutputs(), desc));
        this.rootTasks.add(task);
        task.setFetchSource(true);
        this.setFetchTask(this.createFetchTask("compactionid,dbname,tabname,partname,type,state,workerhost,workerid,enqueuetime,starttime,duration,hadoopjobid,errormessage,initiatorhost,initiatorid,poolname,txnid,nexttxnid,committime,hightestwriteid#string:string:string:string:string:string:string:string:string:string:string:string:string:string:string:string:string:string:string:string"));
    }

    private String processSortOrderSpec(ASTNode sortNode) {
        ArrayList<PTFInvocationSpec.OrderExpression> orderExp = this.processOrderSpec(sortNode).getExpressions();
        Map<String, String> orderByAttributes = orderExp.stream().collect(Collectors.toMap(x -> this.getDbColumnName(x.getExpression()), x -> x.getOrder().toString()));
        return orderByAttributes.entrySet().stream().map(e -> (String)e.getKey() + "\t" + (String)e.getValue()).collect(Collectors.joining(","));
    }

    private String getDbColumnName(ASTNode expression) {
        String dbColumnPrefix = "CC_";
        String dbColumnName = expression.getChild(0) == null ? expression.getText().replace("'", "").toUpperCase() : expression.getChild(0).getText().toUpperCase();
        return EnumUtils.isValidEnum(CompactionColumn.class, (String)dbColumnName) ? CompactionColumn.valueOf(dbColumnName).toString() : "\"" + dbColumnPrefix + dbColumnName + "\"";
    }

    private static enum CompactionColumn {
        COMPACTIONID("\"CC_ID\""),
        DBNAME("\"CC_DATABASE\""),
        TABNAME("\"CC_TABLE\""),
        PARTNAME("\"CC_PARTITION\""),
        ENQUEUETIME("\"CC_ENQUEUE_TIME\""),
        STARTTIME("\"CC_START\""),
        POOLNAME("\"CC_POOL_NAME\""),
        NEXTTXNID("\"CC_NEXT_TXN_ID\""),
        HADOOPJOBID("\"CC_HADOOP_JOB_ID\""),
        WORKERHOST("\"CC_WORKER_ID\""),
        WORKERID("\"CC_WORKER_ID\""),
        DURATION("\"CC_END\""),
        TXNID("\"CC_TXN_ID\""),
        COMMITTIME("CC_COMMIT_TIME"),
        HIGHESTWRITEID("CC_HIGHEST_WRITE_ID");

        private final String colVal;

        private CompactionColumn(String colVal) {
            this.colVal = colVal;
        }

        public String toString() {
            return this.colVal;
        }
    }
}

