/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Date;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.NullUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hive.common.util.DateParser;

public class VectorUDFDateDiffColCol
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private final int colNum2;
    private final transient Date date = new Date(0L);
    private transient LongColumnVector dateVector1;
    private transient LongColumnVector dateVector2;

    public VectorUDFDateDiffColCol(int colNum1, int colNum2, int outputColumnNum) {
        super(colNum1, outputColumnNum);
        this.colNum2 = colNum2;
    }

    public VectorUDFDateDiffColCol() {
        this.colNum2 = -1;
    }

    @Override
    public void transientInit(Configuration conf) throws HiveException {
        super.transientInit(conf);
        this.dateVector1 = new LongColumnVector();
        this.dateVector2 = new LongColumnVector();
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        ColumnVector inputColVector1 = batch.cols[this.inputColumnNum[0]];
        ColumnVector inputColVector2 = batch.cols[this.colNum2];
        int[] sel = batch.selected;
        int n = batch.size;
        LongColumnVector outV = (LongColumnVector)batch.cols[this.outputColumnNum];
        long[] outputVector = outV.vector;
        if (n <= 0) {
            return;
        }
        NullUtil.propagateNullsColCol(inputColVector1, inputColVector2, (ColumnVector)outV, batch.selected, batch.size, batch.selectedInUse);
        LongColumnVector convertedVector1 = this.toDateArray(batch, this.inputTypeInfos[0], inputColVector1, this.dateVector1);
        LongColumnVector convertedVector2 = this.toDateArray(batch, this.inputTypeInfos[1], inputColVector2, this.dateVector2);
        if (inputColVector1.isRepeating && inputColVector2.isRepeating) {
            outV.isRepeating = true;
            if (convertedVector1.isNull[0] || convertedVector2.isNull[0]) {
                outV.isNull[0] = true;
            } else {
                outputVector[0] = convertedVector1.vector[0] - convertedVector2.vector[0];
            }
        } else if (inputColVector1.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (convertedVector1.isNull[0] || convertedVector2.isNull[i]) {
                        outV.isNull[i] = true;
                        continue;
                    }
                    outputVector[i] = convertedVector1.vector[0] - convertedVector2.vector[i];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (convertedVector1.isNull[0] || convertedVector2.isNull[i]) {
                        outV.isNull[i] = true;
                        continue;
                    }
                    outputVector[i] = convertedVector1.vector[0] - convertedVector2.vector[i];
                }
            }
        } else if (inputColVector2.isRepeating) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    if (convertedVector1.isNull[i] || convertedVector2.isNull[0]) {
                        outV.isNull[i] = true;
                        continue;
                    }
                    outputVector[i] = convertedVector1.vector[i] - convertedVector2.vector[0];
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    if (convertedVector1.isNull[i] || convertedVector2.isNull[0]) {
                        outV.isNull[i] = true;
                        continue;
                    }
                    outputVector[i] = convertedVector1.vector[i] - convertedVector2.vector[0];
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (convertedVector1.isNull[i] || convertedVector2.isNull[i]) {
                    outV.isNull[i] = true;
                    continue;
                }
                outputVector[i] = convertedVector1.vector[i] - convertedVector2.vector[i];
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (convertedVector1.isNull[i] || convertedVector2.isNull[i]) {
                    outV.isNull[i] = true;
                    continue;
                }
                outputVector[i] = convertedVector1.vector[i] - convertedVector2.vector[i];
            }
        }
    }

    private LongColumnVector toDateArray(VectorizedRowBatch batch, TypeInfo typeInfo, ColumnVector inputColVector, LongColumnVector dateVector) {
        PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = ((PrimitiveTypeInfo)typeInfo).getPrimitiveCategory();
        int size = batch.size;
        if (primitiveCategory == PrimitiveObjectInspector.PrimitiveCategory.DATE) {
            return (LongColumnVector)inputColVector;
        }
        if (size > dateVector.vector.length) {
            dateVector = this.dateVector1 == dateVector ? (this.dateVector1 = new LongColumnVector(size * 2)) : (this.dateVector2 = new LongColumnVector(size * 2));
        }
        switch (primitiveCategory) {
            case TIMESTAMP: {
                TimestampColumnVector tcv = (TimestampColumnVector)inputColVector;
                this.copySelected(tcv, batch.selectedInUse, batch.selected, batch.size, dateVector);
                return dateVector;
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                BytesColumnVector bcv = (BytesColumnVector)inputColVector;
                this.copySelected(bcv, batch.selectedInUse, batch.selected, batch.size, dateVector);
                return dateVector;
            }
        }
        throw new Error("Unsupported input type " + primitiveCategory.name());
    }

    public void copySelected(BytesColumnVector input, boolean selectedInUse, int[] sel, int size, LongColumnVector output) {
        output.isRepeating = false;
        if (input.isRepeating) {
            if (input.noNulls || !input.isNull[0]) {
                String string = new String(input.vector[0], input.start[0], input.length[0]);
                org.apache.hadoop.hive.common.type.Date hiveDate = DateParser.parseDate((String)string);
                if (hiveDate != null) {
                    output.vector[0] = hiveDate.toEpochDay();
                    output.isNull[0] = false;
                } else {
                    output.isNull[0] = true;
                    output.noNulls = false;
                }
            } else {
                output.isNull[0] = true;
                output.noNulls = false;
            }
            output.isRepeating = true;
            return;
        }
        if (input.noNulls) {
            if (selectedInUse) {
                if (!output.noNulls) {
                    for (int j = 0; j < size; ++j) {
                        int i = sel[j];
                        output.isNull[i] = false;
                        this.setDays(input, output, i);
                    }
                } else {
                    for (int j = 0; j < size; ++j) {
                        int i = sel[j];
                        this.setDays(input, output, i);
                    }
                }
            } else {
                if (!output.noNulls) {
                    Arrays.fill(output.isNull, false);
                    output.noNulls = true;
                }
                for (int i = 0; i < size; ++i) {
                    this.setDays(input, output, i);
                }
            }
        } else {
            int i;
            int j;
            output.noNulls = false;
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = sel[j];
                    output.isNull[i] = input.isNull[i];
                }
            } else {
                System.arraycopy(input.isNull, 0, output.isNull, 0, size);
            }
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = sel[j];
                    if (input.isNull[i]) continue;
                    this.setDays(input, output, i);
                }
            } else {
                for (int i2 = 0; i2 < size; ++i2) {
                    if (input.isNull[i2]) continue;
                    this.setDays(input, output, i2);
                }
            }
        }
    }

    private void setDays(BytesColumnVector input, LongColumnVector output, int i) {
        String string = new String(input.vector[i], input.start[i], input.length[i]);
        org.apache.hadoop.hive.common.type.Date hiveDate = DateParser.parseDate((String)string);
        if (hiveDate != null) {
            output.vector[i] = hiveDate.toEpochDay();
        } else {
            output.isNull[i] = true;
            output.noNulls = false;
        }
    }

    public void copySelected(TimestampColumnVector input, boolean selectedInUse, int[] sel, int size, LongColumnVector output) {
        output.isRepeating = false;
        if (input.isRepeating) {
            if (input.noNulls || !input.isNull[0]) {
                this.date.setTime(input.getTime(0));
                output.vector[0] = DateWritableV2.dateToDays((Date)this.date);
                output.isNull[0] = false;
            } else {
                output.isNull[0] = true;
                output.noNulls = false;
            }
            output.isRepeating = true;
            return;
        }
        if (input.noNulls) {
            if (selectedInUse) {
                if (!output.noNulls) {
                    for (int j = 0; j < size; ++j) {
                        int i = sel[j];
                        this.date.setTime(input.getTime(i));
                        output.vector[i] = DateWritableV2.dateToDays((Date)this.date);
                        output.isNull[i] = false;
                    }
                } else {
                    for (int j = 0; j < size; ++j) {
                        int i = sel[j];
                        this.date.setTime(input.getTime(i));
                        output.vector[i] = DateWritableV2.dateToDays((Date)this.date);
                    }
                }
            } else {
                if (!output.noNulls) {
                    Arrays.fill(output.isNull, false);
                    output.noNulls = true;
                }
                for (int i = 0; i < size; ++i) {
                    this.date.setTime(input.getTime(i));
                    output.vector[i] = DateWritableV2.dateToDays((Date)this.date);
                }
            }
        } else {
            int i;
            int j;
            output.noNulls = false;
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = sel[j];
                    output.isNull[i] = input.isNull[i];
                }
            } else {
                System.arraycopy(input.isNull, 0, output.isNull, 0, size);
            }
            if (selectedInUse) {
                for (j = 0; j < size; ++j) {
                    i = sel[j];
                    if (input.isNull[i]) continue;
                    this.date.setTime(input.getTime(i));
                    output.vector[i] = DateWritableV2.dateToDays((Date)this.date);
                }
            } else {
                for (int i2 = 0; i2 < size; ++i2) {
                    if (input.isNull[i2]) continue;
                    this.date.setTime(input.getTime(i2));
                    output.vector[i2] = DateWritableV2.dateToDays((Date)this.date);
                }
            }
        }
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", " + this.getColumnParamString(1, this.colNum2);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY, VectorExpressionDescriptor.ArgumentType.STRING_DATETIME_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

