/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions.gen;

import java.util.Arrays;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.DecimalUtil;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;

public class DecimalColumnNotBetween
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    protected final HiveDecimal leftValue;
    protected final HiveDecimal rightValue;

    public DecimalColumnNotBetween() {
        this.leftValue = null;
        this.rightValue = null;
    }

    public DecimalColumnNotBetween(int colNum, HiveDecimal leftValue, HiveDecimal rightValue, int outputColumnNum) {
        super(colNum, outputColumnNum);
        this.leftValue = leftValue;
        this.rightValue = rightValue;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inputColumnVector = (DecimalColumnVector)batch.cols[this.inputColumnNum[0]];
        LongColumnVector outputColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        int[] sel = batch.selected;
        boolean[] inputIsNull = inputColumnVector.isNull;
        boolean[] outputIsNull = outputColVector.isNull;
        int n = batch.size;
        HiveDecimalWritable[] vector = inputColumnVector.vector;
        long[] outputVector = outputColVector.vector;
        if (n == 0) {
            return;
        }
        outputColVector.isRepeating = false;
        if (inputColumnVector.isRepeating) {
            if (inputColumnVector.noNulls || !inputIsNull[0]) {
                outputIsNull[0] = false;
                HiveDecimalWritable repeatValue = vector[0];
                outputVector[0] = DecimalUtil.compare(repeatValue, this.leftValue) >= 0 && DecimalUtil.compare(repeatValue, this.rightValue) <= 0 ? 0L : 1L;
            } else {
                outputIsNull[0] = true;
                outputColVector.noNulls = false;
            }
            outputColVector.isRepeating = true;
            return;
        }
        if (inputColumnVector.noNulls) {
            if (batch.selectedInUse) {
                if (!outputColVector.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        HiveDecimalWritable value = vector[i];
                        outputVector[i] = DecimalUtil.compare(value, this.leftValue) >= 0 && DecimalUtil.compare(value, this.rightValue) <= 0 ? 0L : 1L;
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        HiveDecimalWritable value = vector[i];
                        outputVector[i] = DecimalUtil.compare(value, this.leftValue) >= 0 && DecimalUtil.compare(value, this.rightValue) <= 0 ? 0L : 1L;
                    }
                }
            } else {
                if (!outputColVector.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outputColVector.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    HiveDecimalWritable value = vector[i];
                    outputVector[i] = DecimalUtil.compare(value, this.leftValue) >= 0 && DecimalUtil.compare(value, this.rightValue) <= 0 ? 0L : 1L;
                }
            }
        } else {
            outputColVector.noNulls = false;
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outputIsNull[i] = inputIsNull[i];
                    if (inputIsNull[i]) continue;
                    HiveDecimalWritable value = vector[i];
                    outputVector[i] = DecimalUtil.compare(value, this.leftValue) >= 0 && DecimalUtil.compare(value, this.rightValue) <= 0 ? 0L : 1L;
                }
            } else {
                System.arraycopy(inputIsNull, 0, outputIsNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inputIsNull[i]) continue;
                    HiveDecimalWritable value = vector[i];
                    outputVector[i] = DecimalUtil.compare(value, this.leftValue) >= 0 && DecimalUtil.compare(value, this.rightValue) <= 0 ? 0L : 1L;
                }
            }
        }
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return null;
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.inputColumnNum[0]) + ", left " + this.leftValue.toString() + ", right " + this.rightValue.toString();
    }
}

