/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Weigher;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.TableName;
import org.apache.hadoop.hive.common.ValidTxnWriteIdList;
import org.apache.hadoop.hive.common.ValidWriteIdList;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.AggrStats;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesRequest;
import org.apache.hadoop.hive.metastore.api.GetPartitionsByNamesResult;
import org.apache.hadoop.hive.metastore.api.GetTableRequest;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionsByExprRequest;
import org.apache.hadoop.hive.metastore.api.PartitionsStatsRequest;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.MetaStoreClientWrapper;
import org.apache.hadoop.hive.metastore.client.utils.HiveMetaStoreClientUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.client.MetaStoreClientCacheUtils;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.hive.ql.util.IncrementalObjectSizeEstimator;
import org.apache.thrift.TException;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveMetaStoreClientWithLocalCache
extends MetaStoreClientWrapper {
    private static final Logger LOG = LoggerFactory.getLogger(HiveMetaStoreClientWithLocalCache.class);
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static Cache<MetaStoreClientCacheUtils.CacheKey, Object> mscLocalCache = null;
    private static long maxSize;
    private static boolean recordStats;
    private static HashMap<Class<?>, IncrementalObjectSizeEstimator.ObjectEstimator> sizeEstimator;
    private static String cacheObjName;

    public static HiveMetaStoreClientWithLocalCache newClient(Configuration conf, IMetaStoreClient delegate) {
        return new HiveMetaStoreClientWithLocalCache(conf, delegate);
    }

    public HiveMetaStoreClientWithLocalCache(Configuration conf, IMetaStoreClient delegate) {
        super(delegate, conf);
    }

    public static synchronized void init(Configuration conf) {
        if (!INITIALIZED.get()) {
            LOG.info("Initializing local cache in HiveMetaStoreClient...");
            maxSize = HiveConf.getSizeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MSC_CACHE_MAX_SIZE);
            recordStats = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MSC_CACHE_RECORD_STATS);
            HiveMetaStoreClientWithLocalCache.initSizeEstimator();
            HiveMetaStoreClientWithLocalCache.initCache();
            LOG.info("Local cache initialized in HiveMetaStoreClient: {}", mscLocalCache);
            INITIALIZED.set(true);
        }
    }

    private static void initSizeEstimator() {
        sizeEstimator = new HashMap();
        IncrementalObjectSizeEstimator.createEstimators(MetaStoreClientCacheUtils.CacheKey.class, sizeEstimator);
        for (MetaStoreClientCacheUtils.KeyType e : MetaStoreClientCacheUtils.KeyType.values()) {
            for (Class<?> c : e.keyClasses) {
                IncrementalObjectSizeEstimator.createEstimators(c, sizeEstimator);
            }
            IncrementalObjectSizeEstimator.createEstimators(e.valueClass, sizeEstimator);
        }
    }

    private static void initCache() {
        int initSize = 100;
        Weigher<MetaStoreClientCacheUtils.CacheKey, Object> weigher = new Weigher<MetaStoreClientCacheUtils.CacheKey, Object>(){

            public @NonNegative int weigh(@NonNull MetaStoreClientCacheUtils.CacheKey key, @NonNull Object val) {
                return MetaStoreClientCacheUtils.getWeight(key, val, sizeEstimator);
            }
        };
        Caffeine cacheBuilder = Caffeine.newBuilder().initialCapacity(initSize).maximumWeight(maxSize).weigher((Weigher)weigher).removalListener((key, val, cause) -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Caffeine - ({}, {}) was removed ({})", new Object[]{key, val, cause});
            }
        });
        if (recordStats) {
            cacheBuilder.recordStats();
        }
        mscLocalCache = cacheBuilder.build();
        cacheObjName = cacheBuilder.toString();
    }

    private boolean isCacheEnabledAndInitialized() {
        SessionState sessionState = SessionState.get();
        if (sessionState == null || sessionState.getQueryCache(MetaStoreClientCacheUtils.getQueryId()) == null) {
            return false;
        }
        return INITIALIZED.get();
    }

    public Table getTable(GetTableRequest req) throws TException {
        MetaStoreClientCacheUtils.TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new MetaStoreClientCacheUtils.TableWatermark(req.getValidWriteIdList(), req.getId())).isValid()) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.TABLE, req);
            Table r = (Table)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = this.delegate.getTable(req);
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else {
                LOG.debug("HS2 level HMS cache: method=getTableInternal, dbName={}, tblName={}, columnStats={}", new Object[]{req.getDbName(), req.getTblName(), req.isGetColumnStats()});
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return this.delegate.getTable(req);
    }

    public boolean tableExists(String catName, String dbName, String tableName) throws TException {
        try {
            GetTableRequest req = new GetTableRequest(dbName, tableName);
            req.setCatName(catName);
            return this.getTable(req) != null;
        }
        catch (NoSuchObjectException e) {
            return false;
        }
    }

    public boolean listPartitionsByExpr(final PartitionsByExprRequest req, List<Partition> result) throws TException {
        MetaStoreClientCacheUtils.Supplier<MetaStoreClientCacheUtils.PartitionsWrapper, TException> supplier = new MetaStoreClientCacheUtils.Supplier<MetaStoreClientCacheUtils.PartitionsWrapper, TException>(){

            @Override
            public MetaStoreClientCacheUtils.PartitionsWrapper get() throws TException {
                ArrayList<Partition> parts = new ArrayList<Partition>();
                boolean hasUnknownPart = HiveMetaStoreClientWithLocalCache.this.delegate.listPartitionsByExpr(req, parts);
                return new MetaStoreClientCacheUtils.PartitionsWrapper(parts, hasUnknownPart);
            }
        };
        MetaStoreClientCacheUtils.PartitionsWrapper r = this.getPartitionsByExprInternal(req, supplier);
        result.addAll(r.partitions);
        return r.hasUnknownPartition;
    }

    private MetaStoreClientCacheUtils.PartitionsWrapper getPartitionsByExprInternal(PartitionsByExprRequest req, MetaStoreClientCacheUtils.Supplier<MetaStoreClientCacheUtils.PartitionsWrapper, TException> supplier) throws TException {
        MetaStoreClientCacheUtils.TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new MetaStoreClientCacheUtils.TableWatermark(req.getValidWriteIdList(), this.getTable(req.getCatName(), req.getDbName(), req.getTblName()).getId())).isValid()) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.PARTITIONS_BY_EXPR, watermark, req);
            MetaStoreClientCacheUtils.PartitionsWrapper r = (MetaStoreClientCacheUtils.PartitionsWrapper)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = supplier.get();
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else {
                LOG.debug("HS2 level HMS cache: method=getPartitionsByExprInternal, dbName={}, tblName={}", (Object)req.getDbName(), (Object)req.getTblName());
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return supplier.get();
    }

    public List<String> listPartitionNames(String catName, String dbName, String tableName, int maxParts) throws TException {
        MetaStoreClientCacheUtils.TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new MetaStoreClientCacheUtils.TableWatermark(this.getValidWriteIdList(dbName, tableName), this.getTable(catName, dbName, tableName).getId())).isValid()) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.LIST_PARTITIONS_ALL, watermark, catName, dbName, tableName, maxParts);
            MetaStoreClientCacheUtils.PartitionNamesWrapper r = (MetaStoreClientCacheUtils.PartitionNamesWrapper)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = new MetaStoreClientCacheUtils.PartitionNamesWrapper(this.delegate.listPartitionNames(catName, dbName, tableName, maxParts));
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else {
                LOG.debug("HS2 level HMS cache: method=listPartitionNamesInternal, dbName={}, tblName={}", (Object)dbName, (Object)tableName);
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r.partitionNames;
        }
        return this.delegate.listPartitionNames(catName, dbName, tableName, maxParts);
    }

    public boolean listPartitionsSpecByExpr(final PartitionsByExprRequest req, List<PartitionSpec> result) throws TException {
        MetaStoreClientCacheUtils.Supplier<MetaStoreClientCacheUtils.PartitionSpecsWrapper, TException> supplier = new MetaStoreClientCacheUtils.Supplier<MetaStoreClientCacheUtils.PartitionSpecsWrapper, TException>(){

            @Override
            public MetaStoreClientCacheUtils.PartitionSpecsWrapper get() throws TException {
                ArrayList<PartitionSpec> parts = new ArrayList<PartitionSpec>();
                boolean hasUnknownPart = HiveMetaStoreClientWithLocalCache.this.delegate.listPartitionsSpecByExpr(req, parts);
                return new MetaStoreClientCacheUtils.PartitionSpecsWrapper(parts, hasUnknownPart);
            }
        };
        MetaStoreClientCacheUtils.PartitionSpecsWrapper r = this.getPartitionsSpecByExprInternal(req, supplier);
        result.addAll(r.partitionSpecs);
        return r.hasUnknownPartition;
    }

    private MetaStoreClientCacheUtils.PartitionSpecsWrapper getPartitionsSpecByExprInternal(PartitionsByExprRequest req, MetaStoreClientCacheUtils.Supplier<MetaStoreClientCacheUtils.PartitionSpecsWrapper, TException> supplier) throws TException {
        MetaStoreClientCacheUtils.TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new MetaStoreClientCacheUtils.TableWatermark(req.getValidWriteIdList(), this.getTable(req.getCatName(), req.getDbName(), req.getTblName()).getId())).isValid()) {
            MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.PARTITIONS_SPEC_BY_EXPR, watermark, req);
            MetaStoreClientCacheUtils.PartitionSpecsWrapper r = (MetaStoreClientCacheUtils.PartitionSpecsWrapper)mscLocalCache.getIfPresent((Object)cacheKey);
            if (r == null) {
                r = supplier.get();
                mscLocalCache.put((Object)cacheKey, (Object)r);
            } else {
                LOG.debug("HS2 level HMS cache: method=getPartitionsSpecByExprInternal, dbName={}, tblName={}", (Object)req.getDbName(), (Object)req.getTblName());
            }
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return r;
        }
        return supplier.get();
    }

    public List<ColumnStatisticsObj> getTableColumnStatistics(String catName, String dbName, String tableName, List<String> colNames, String engine, String validWriteIdList) throws TException {
        MetaStoreClientCacheUtils.TableWatermark watermark;
        if (this.isCacheEnabledAndInitialized() && (watermark = new MetaStoreClientCacheUtils.TableWatermark(this.getValidWriteIdList(dbName, tableName), this.getTable(catName, dbName, tableName).getId())).isValid()) {
            MetaStoreClientCacheUtils.CacheWrapper cache = new MetaStoreClientCacheUtils.CacheWrapper(mscLocalCache);
            Pair<List<ColumnStatisticsObj>, List<String>> p = MetaStoreClientCacheUtils.getTableColumnStatisticsCache(cache, catName, dbName, tableName, colNames, engine, validWriteIdList, watermark);
            List colStatsMissing = (List)p.getRight();
            List colStats = (List)p.getLeft();
            if (colStatsMissing.isEmpty()) {
                return colStats;
            }
            List newColStats = this.delegate.getTableColumnStatistics(catName, dbName, tableName, colStatsMissing, engine, validWriteIdList);
            MetaStoreClientCacheUtils.loadTableColumnStatisticsCache(cache, newColStats, catName, dbName, tableName, engine, validWriteIdList, watermark);
            List<ColumnStatisticsObj> result = MetaStoreClientCacheUtils.computeTableColumnStatisticsFinal(colNames, colStats, newColStats);
            if (LOG.isDebugEnabled() && recordStats) {
                LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
            }
            return result;
        }
        return this.delegate.getTableColumnStatistics(catName, dbName, tableName, colNames, engine, validWriteIdList);
    }

    public AggrStats getAggrColStatsFor(String catName, String dbName, String tblName, List<String> colNames, List<String> partNames, String engine) throws TException {
        return this.getAggrColStatsFor(catName, dbName, tblName, colNames, partNames, engine, this.getValidWriteIdList(dbName, tblName));
    }

    public AggrStats getAggrColStatsFor(String catName, String dbName, String tblName, List<String> colNames, List<String> partNames, String engine, String writeIdList) throws TException {
        if (this.isCacheEnabledAndInitialized()) {
            PartitionsStatsRequest req = new PartitionsStatsRequest(dbName, tblName, colNames, partNames);
            req.setEngine(engine);
            req.setCatName(catName);
            req.setValidWriteIdList(writeIdList);
            MetaStoreClientCacheUtils.TableWatermark watermark = new MetaStoreClientCacheUtils.TableWatermark(writeIdList, this.getTable(catName, dbName, tblName).getId());
            if (watermark.isValid()) {
                MetaStoreClientCacheUtils.CacheKey cacheKey = new MetaStoreClientCacheUtils.CacheKey(MetaStoreClientCacheUtils.KeyType.AGGR_COL_STATS, watermark, req);
                AggrStats r = (AggrStats)mscLocalCache.getIfPresent((Object)cacheKey);
                if (r == null) {
                    r = this.delegate.getAggrColStatsFor(catName, dbName, tblName, colNames, partNames, engine, writeIdList);
                    mscLocalCache.put((Object)cacheKey, (Object)r);
                } else {
                    LOG.debug("HS2 level HMS cache: method=getAggrStatsForInternal, dbName={}, tblName={}, partNames={}", new Object[]{dbName, tblName, partNames});
                }
                if (LOG.isDebugEnabled() && recordStats) {
                    LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
                }
                return r;
            }
        }
        return this.delegate.getAggrColStatsFor(catName, dbName, tblName, colNames, partNames, engine, writeIdList);
    }

    public GetPartitionsByNamesResult getPartitionsByNames(GetPartitionsByNamesRequest req) throws TException {
        if (this.isCacheEnabledAndInitialized()) {
            String dbName = MetaStoreUtils.parseDbName((String)req.getDb_name(), (Configuration)this.conf)[1];
            MetaStoreClientCacheUtils.TableWatermark watermark = new MetaStoreClientCacheUtils.TableWatermark(req.getValidWriteIdList(), this.getTable(dbName, req.getTbl_name()).getId());
            if (watermark.isValid()) {
                MetaStoreClientCacheUtils.CacheWrapper cache = new MetaStoreClientCacheUtils.CacheWrapper(mscLocalCache);
                Pair<List<Partition>, List<String>> p = MetaStoreClientCacheUtils.getPartitionsByNamesCache(cache, req, watermark);
                List partitionsMissing = (List)p.getRight();
                List partitions = (List)p.getLeft();
                if (partitionsMissing.isEmpty()) {
                    return new GetPartitionsByNamesResult(partitions);
                }
                GetPartitionsByNamesRequest newRqst = new GetPartitionsByNamesRequest(req);
                newRqst.setNames(partitionsMissing);
                GetPartitionsByNamesResult r = this.delegate.getPartitionsByNames(newRqst);
                List<Partition> newPartitions = MetaStoreClientCacheUtils.loadPartitionsByNamesCache(cache, r, req, watermark);
                GetPartitionsByNamesResult result = MetaStoreClientCacheUtils.computePartitionsByNamesFinal(req, partitions, newPartitions);
                if (LOG.isDebugEnabled() && recordStats) {
                    LOG.debug(cacheObjName + ": " + mscLocalCache.stats().toString());
                }
                return result;
            }
        }
        return this.delegate.getPartitionsByNames(req);
    }

    private String getValidWriteIdList(String dbName, String tblName) {
        try {
            String validTxnsList = Hive.get().getConf().get("hive.txn.valid.txns");
            if (validTxnsList == null) {
                return HiveMetaStoreClientUtils.getValidWriteIdList((String)dbName, (String)tblName, (Configuration)this.conf);
            }
            if (!AcidUtils.isTransactionalTable(this.getTable(dbName, tblName))) {
                return null;
            }
            String validWriteIds = Hive.get().getConf().get("hive.txn.tables.valid.writeids");
            String fullTableName = TableName.getDbTable((String)dbName, (String)tblName);
            ValidTxnWriteIdList validTxnWriteIdList = validWriteIds != null ? ValidTxnWriteIdList.fromValue((String)validWriteIds) : SessionState.get().getTxnMgr().getValidWriteIds((List<String>)ImmutableList.of((Object)fullTableName), validTxnsList);
            ValidWriteIdList writeIdList = validTxnWriteIdList.getTableValidWriteIdList(fullTableName);
            return writeIdList != null ? writeIdList.toString() : null;
        }
        catch (Exception e) {
            throw new RuntimeException("Exception getting valid write id list", e);
        }
    }

    static {
        sizeEstimator = null;
        cacheObjName = null;
    }
}

