/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.secrets;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.curator.utils.CloseableUtils;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.secrets.SecretSource;

public class URISecretSource {
    private static final URISecretSource INSTANCE = new URISecretSource();
    private final Map<String, SecretSource> sourcesMap = new HashMap<String, SecretSource>();

    private URISecretSource() {
        ServiceLoader.load(SecretSource.class).forEach(this::register);
        Runtime.getRuntime().addShutdownHook(new Thread(this::close));
    }

    public static URISecretSource getInstance() {
        return INSTANCE;
    }

    public String getPasswordFromUri(URI uri) throws IOException, HiveException {
        SecretSource source = this.sourcesMap.get(uri.getScheme());
        if (source == null) {
            throw new HiveException("Cannot fine secret source for scheme: " + uri.getScheme());
        }
        return source.getSecret(uri);
    }

    public void register(SecretSource source) {
        SecretSource oldSource = this.sourcesMap.put(source.getURIScheme(), source);
        if (oldSource != null) {
            throw new RuntimeException("Two sources for same scheme: " + source.getURIScheme() + " [" + source.getClass().getName() + " and " + oldSource.getClass().getName() + "]");
        }
    }

    @VisibleForTesting
    void removeForTest(SecretSource source) {
        this.sourcesMap.remove(source.getURIScheme(), source);
    }

    private void close() {
        this.sourcesMap.values().forEach(CloseableUtils::closeQuietly);
    }
}

