/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.Contexts;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.rules.ImmutableFilterSetOpTransposeRule;
import org.apache.calcite.rel.rules.TransformationRule;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.immutables.value.Value;

@Value.Enclosing
public class FilterSetOpTransposeRule
extends RelRule<Config>
implements TransformationRule {
    protected FilterSetOpTransposeRule(Config config) {
        super(config);
    }

    @Deprecated
    public FilterSetOpTransposeRule(RelBuilderFactory relBuilderFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(relBuilderFactory).as(Config.class));
    }

    @Deprecated
    public FilterSetOpTransposeRule(RelFactories.FilterFactory filterFactory) {
        this(Config.DEFAULT.withRelBuilderFactory(RelBuilder.proto(Contexts.of((Object)filterFactory))).as(Config.class));
    }

    @Override
    public void onMatch(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        SetOp setOp = (SetOp)call.rel(1);
        RexNode condition = filterRel.getCondition();
        RexBuilder rexBuilder = filterRel.getCluster().getRexBuilder();
        RelBuilder relBuilder = call.builder();
        List<RelDataTypeField> origFields = setOp.getRowType().getFieldList();
        int[] adjustments = new int[origFields.size()];
        ArrayList<RelNode> newSetOpInputs = new ArrayList<RelNode>();
        for (RelNode input : setOp.getInputs()) {
            RexNode newCondition = condition.accept(new RelOptUtil.RexInputConverter(rexBuilder, origFields, input.getRowType().getFieldList(), adjustments));
            newSetOpInputs.add(relBuilder.push(input).filter(newCondition).build());
        }
        RelNode newSetOp = setOp.copy(setOp.getTraitSet(), newSetOpInputs);
        call.transformTo(newSetOp);
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableFilterSetOpTransposeRule.Config.of().withOperandSupplier(b0 -> b0.operand(Filter.class).oneInput(b1 -> b1.operand(SetOp.class).anyInputs()));

        @Override
        default public FilterSetOpTransposeRule toRule() {
            return new FilterSetOpTransposeRule(this);
        }
    }
}

