/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.BaseChangelogContentScanTask;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.DeletedRowsScanTask;
import org.apache.iceberg.expressions.ResidualEvaluator;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;

class BaseDeletedRowsScanTask
extends BaseChangelogContentScanTask<DeletedRowsScanTask, DataFile>
implements DeletedRowsScanTask {
    private final DeleteFile[] addedDeletes;
    private final DeleteFile[] existingDeletes;

    BaseDeletedRowsScanTask(int changeOrdinal, long commitSnapshotId, DataFile file, DeleteFile[] addedDeletes, DeleteFile[] existingDeletes, String schemaString, String specString, ResidualEvaluator residuals) {
        super(changeOrdinal, commitSnapshotId, file, schemaString, specString, residuals);
        this.addedDeletes = addedDeletes != null ? addedDeletes : new DeleteFile[]{};
        this.existingDeletes = existingDeletes != null ? existingDeletes : new DeleteFile[]{};
    }

    @Override
    protected DeletedRowsScanTask self() {
        return this;
    }

    @Override
    protected DeletedRowsScanTask newSplitTask(DeletedRowsScanTask parentTask, long offset, long length) {
        return new SplitDeletedRowsScanTask(parentTask, offset, length);
    }

    @Override
    public List<DeleteFile> addedDeletes() {
        return ImmutableList.copyOf(this.addedDeletes);
    }

    @Override
    public List<DeleteFile> existingDeletes() {
        return ImmutableList.copyOf(this.existingDeletes);
    }

    private static class SplitDeletedRowsScanTask
    extends BaseChangelogContentScanTask.SplitScanTask<SplitDeletedRowsScanTask, DeletedRowsScanTask, DataFile>
    implements DeletedRowsScanTask {
        SplitDeletedRowsScanTask(DeletedRowsScanTask parentTask, long offset, long length) {
            super(parentTask, offset, length);
        }

        @Override
        protected SplitDeletedRowsScanTask copyWithNewLength(long newLength) {
            return new SplitDeletedRowsScanTask((DeletedRowsScanTask)this.parentTask(), this.start(), newLength);
        }

        @Override
        public List<DeleteFile> addedDeletes() {
            return ((DeletedRowsScanTask)this.parentTask()).addedDeletes();
        }

        @Override
        public List<DeleteFile> existingDeletes() {
            return ((DeletedRowsScanTask)this.parentTask()).existingDeletes();
        }
    }
}

