/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ValidTxnList;
import org.apache.hadoop.hive.metastore.MetastoreTaskThread;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.txn.NoMutex;
import org.apache.hadoop.hive.metastore.txn.TxnCommonUtils;
import org.apache.hadoop.hive.metastore.txn.TxnStore;
import org.apache.hadoop.hive.metastore.txn.TxnUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializationsRebuildLockCleanerTask
implements MetastoreTaskThread {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializationsRebuildLockCleanerTask.class);
    private Configuration conf;
    private TxnStore txnHandler;
    private boolean shouldUseMutex = true;

    public long runFrequency(TimeUnit unit) {
        return MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_TIMEOUT, (TimeUnit)unit) / 2L;
    }

    public void setConf(Configuration configuration) {
        this.conf = configuration;
        this.txnHandler = TxnUtils.getTxnStore(this.conf);
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void run() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleaning up materialization rebuild locks");
        }
        TxnStore.MutexAPI mutex = this.shouldUseMutex ? this.txnHandler.getMutexAPI() : new NoMutex();
        try (TxnStore.MutexAPI.LockHandle closeable = mutex.acquireLock(TxnStore.MUTEX_KEY.MaterializationRebuild.name());){
            ValidTxnList validTxnList = TxnCommonUtils.createValidReadTxnList((GetOpenTxnsResponse)this.txnHandler.getOpenTxns(), (long)0L);
            long removedCnt = this.txnHandler.cleanupMaterializationRebuildLocks(validTxnList, MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.TXN_TIMEOUT, (TimeUnit)TimeUnit.MILLISECONDS));
            if (removedCnt > 0L && LOG.isDebugEnabled()) {
                LOG.debug("Number of materialization locks deleted: " + removedCnt);
            }
        }
        catch (Throwable t) {
            LOG.error("Unexpected error in thread: {}, message: {}", new Object[]{Thread.currentThread().getName(), t.getMessage(), t});
        }
    }

    public void enforceMutex(boolean enableMutex) {
        this.shouldUseMutex = enableMutex;
    }
}

