/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.llap.tezplugins.metrics;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.daemon.rpc.LlapDaemonProtocolProtos;
import org.apache.hadoop.hive.llap.impl.LlapManagementProtocolClientImpl;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstance;
import org.apache.hadoop.hive.llap.registry.LlapServiceInstanceSet;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.llap.tezplugins.metrics.LlapManagementProtocolClientImplFactory;
import org.apache.hadoop.hive.llap.tezplugins.metrics.LlapMetricsListener;
import org.apache.hadoop.hive.registry.ServiceInstanceStateChangeListener;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.service.ServiceStateChangeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LlapMetricsCollector
implements ServiceStateChangeListener,
ServiceInstanceStateChangeListener<LlapServiceInstance> {
    private static final Logger LOG = LoggerFactory.getLogger(LlapMetricsCollector.class);
    private static final String THREAD_NAME = "LlapTaskSchedulerMetricsCollectorThread";
    private static final long INITIAL_DELAY_MSEC = 10000L;
    private final ScheduledExecutorService scheduledMetricsExecutor;
    private final LlapManagementProtocolClientImplFactory clientFactory;
    private final Map<String, LlapManagementProtocolClientImpl> llapClients;
    private final Map<String, LlapMetrics> instanceStatisticsMap;
    private final long metricsCollectionMs;
    @VisibleForTesting
    final LlapMetricsListener listener;

    public LlapMetricsCollector(Configuration conf, LlapRegistryService registry) {
        this(conf, Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat(THREAD_NAME).build()), LlapManagementProtocolClientImplFactory.basicInstance(conf), registry);
    }

    @VisibleForTesting
    LlapMetricsCollector(Configuration conf, ScheduledExecutorService scheduledMetricsExecutor, LlapManagementProtocolClientImplFactory clientFactory) {
        this(conf, scheduledMetricsExecutor, clientFactory, null);
    }

    @VisibleForTesting
    LlapMetricsCollector(Configuration conf, ScheduledExecutorService scheduledMetricsExecutor, LlapManagementProtocolClientImplFactory clientFactory, LlapRegistryService registry) {
        this.scheduledMetricsExecutor = scheduledMetricsExecutor;
        this.clientFactory = clientFactory;
        this.llapClients = new HashMap<String, LlapManagementProtocolClientImpl>();
        this.instanceStatisticsMap = new ConcurrentHashMap<String, LlapMetrics>();
        this.metricsCollectionMs = HiveConf.getTimeVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TASK_SCHEDULER_AM_COLLECT_DAEMON_METRICS_MS, (TimeUnit)TimeUnit.MILLISECONDS);
        String listenerClass = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_TASK_SCHEDULER_AM_COLLECT_DAEMON_METRICS_LISTENER);
        if (listenerClass == null || listenerClass.isEmpty()) {
            this.listener = null;
        } else {
            try {
                this.listener = (LlapMetricsListener)Class.forName(listenerClass.trim()).newInstance();
                this.listener.init(conf, registry);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Wrong configuration for " + String.valueOf(HiveConf.ConfVars.LLAP_TASK_SCHEDULER_AM_COLLECT_DAEMON_METRICS_LISTENER) + " " + listenerClass, e);
            }
        }
    }

    public void start() {
        if (this.metricsCollectionMs > 0L) {
            this.scheduledMetricsExecutor.scheduleAtFixedRate(() -> this.collectMetrics(), 10000L, this.metricsCollectionMs, TimeUnit.MILLISECONDS);
        }
    }

    public void shutdown() {
        this.scheduledMetricsExecutor.shutdownNow();
    }

    @VisibleForTesting
    void collectMetrics() {
        for (Map.Entry<String, LlapManagementProtocolClientImpl> entry : this.llapClients.entrySet()) {
            String identity = entry.getKey();
            LlapManagementProtocolClientImpl client = entry.getValue();
            try {
                LlapDaemonProtocolProtos.GetDaemonMetricsResponseProto metrics = client.getDaemonMetrics(null, LlapDaemonProtocolProtos.GetDaemonMetricsRequestProto.newBuilder().build());
                LlapMetrics newMetrics = new LlapMetrics(metrics);
                this.instanceStatisticsMap.put(identity, newMetrics);
                if (this.listener == null) continue;
                try {
                    this.listener.newDaemonMetrics(identity, newMetrics);
                }
                catch (Throwable t) {
                    LOG.warn("LlapMetricsListener thrown an unexpected exception", t);
                }
            }
            catch (ServiceException ex) {
                LOG.error(ex.getMessage(), (Throwable)ex);
                this.instanceStatisticsMap.remove(identity);
            }
        }
        if (this.listener != null) {
            try {
                this.listener.newClusterMetrics(this.getMetrics());
            }
            catch (Throwable t) {
                LOG.warn("LlapMetricsListener thrown an unexpected exception", t);
            }
        }
    }

    public void stateChanged(Service service) {
        if (service.getServiceState() == Service.STATE.STARTED) {
            if (service instanceof LlapRegistryService) {
                this.setupLlapRegistryService((LlapRegistryService)service);
            }
            this.start();
        } else if (service.getServiceState() == Service.STATE.STOPPED) {
            this.shutdown();
        }
    }

    private void setupLlapRegistryService(LlapRegistryService service) {
        try {
            this.consumeInitialInstances(service);
            service.registerStateChangeListener((ServiceInstanceStateChangeListener)this);
        }
        catch (IOException ex) {
            LOG.error(ex.getMessage(), (Throwable)ex);
        }
    }

    @VisibleForTesting
    void consumeInitialInstances(LlapRegistryService service) throws IOException {
        LlapServiceInstanceSet serviceInstances = service.getInstances();
        for (LlapServiceInstance serviceInstance : serviceInstances.getAll()) {
            this.onCreate(serviceInstance, -1);
        }
    }

    public void onCreate(LlapServiceInstance serviceInstance, int ephSeqVersion) {
        LlapManagementProtocolClientImpl client = this.clientFactory.create(serviceInstance);
        this.llapClients.put(serviceInstance.getWorkerIdentity(), client);
    }

    public void onUpdate(LlapServiceInstance serviceInstance, int ephSeqVersion) {
    }

    public void onRemove(LlapServiceInstance serviceInstance, int ephSeqVersion) {
        String workerIdentity = serviceInstance.getWorkerIdentity();
        this.llapClients.remove(workerIdentity);
        this.instanceStatisticsMap.remove(workerIdentity);
    }

    public LlapMetrics getMetrics(String workerIdentity) {
        return this.instanceStatisticsMap.get(workerIdentity);
    }

    public Map<String, LlapMetrics> getMetrics() {
        return Collections.unmodifiableMap(this.instanceStatisticsMap);
    }

    public static class LlapMetrics {
        private final long timestamp;
        private final Map<String, Long> metrics;

        @VisibleForTesting
        LlapMetrics(long timestamp, Map<String, Long> metrics) {
            this.timestamp = timestamp;
            this.metrics = metrics;
        }

        public LlapMetrics(LlapDaemonProtocolProtos.GetDaemonMetricsResponseProto metrics) {
            this.timestamp = System.currentTimeMillis();
            this.metrics = new HashMap<String, Long>(metrics.getMetricsCount());
            metrics.getMetricsList().forEach(entry -> this.metrics.put(entry.getKey(), entry.getValue()));
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public Map<String, Long> getMetrics() {
            return this.metrics;
        }
    }
}

