/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.key;

import java.util.Map;
import org.datanucleus.store.rdbms.key.CandidateKey;
import org.datanucleus.store.rdbms.key.ColumnOrderedKey;
import org.datanucleus.store.rdbms.key.ForeignKey;
import org.datanucleus.store.rdbms.table.Table;

public class Index
extends ColumnOrderedKey {
    public static final String EXTENSION_INDEX_EXTENDED_SETTING = "extended-setting";
    public static final String EXTENSION_INDEX_TYPE = "index-type";
    private final boolean isUnique;

    public Index(Table table, boolean isUnique, Map<String, String> extensions) {
        super(table, extensions);
        this.isUnique = isUnique;
    }

    public Index(CandidateKey ck) {
        super(ck.getTable(), null);
        this.isUnique = true;
        this.columns.addAll(ck.getColumns());
        int numCols = this.columns.size();
        for (int i = 0; i < numCols; ++i) {
            this.columnOrdering.add(Boolean.TRUE);
        }
    }

    public Index(ForeignKey fk) {
        super(fk.getTable(), null);
        this.isUnique = false;
        this.columns.addAll(fk.getColumns());
        int numCols = this.columns.size();
        for (int i = 0; i < numCols; ++i) {
            this.columnOrdering.add(Boolean.TRUE);
        }
    }

    public boolean getUnique() {
        return this.isUnique;
    }

    @Override
    public int hashCode() {
        return (this.isUnique ? 0 : 1) ^ super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Index)) {
            return false;
        }
        Index idx = (Index)obj;
        if (idx.isUnique != this.isUnique) {
            return false;
        }
        return super.equals(obj);
    }

    public String toString() {
        return "INDEX " + Index.getColumnList(this.columns);
    }
}

