/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.Envelope2D;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryException;
import com.esri.core.geometry.MultiPathImpl;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Point2D;
import com.esri.core.geometry.PointInPolygonHelper;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.RasterizedGeometry2D;
import com.esri.core.geometry.Segment;

final class PolygonUtils {
    PolygonUtils() {
    }

    public static PiPResult isPointInPolygon2D(Polygon polygon, Point inputPoint, double tolerance) {
        int res = PointInPolygonHelper.isPointInPolygon(polygon, inputPoint, tolerance);
        if (res == 0) {
            return PiPResult.PiPOutside;
        }
        if (res == 1) {
            return PiPResult.PiPInside;
        }
        return PiPResult.PiPBoundary;
    }

    public static PiPResult isPointInPolygon2D(Polygon polygon, Point2D inputPoint, double tolerance) {
        int res = PointInPolygonHelper.isPointInPolygon(polygon, inputPoint, tolerance);
        if (res == 0) {
            return PiPResult.PiPOutside;
        }
        if (res == 1) {
            return PiPResult.PiPInside;
        }
        return PiPResult.PiPBoundary;
    }

    static PiPResult isPointInPolygon2D(Polygon polygon, double inputPointXVal, double inputPointYVal, double tolerance) {
        int res = PointInPolygonHelper.isPointInPolygon(polygon, inputPointXVal, inputPointYVal, tolerance);
        if (res == 0) {
            return PiPResult.PiPOutside;
        }
        if (res == 1) {
            return PiPResult.PiPInside;
        }
        return PiPResult.PiPBoundary;
    }

    public static PiPResult isPointInRing2D(Polygon polygon, int iRing, Point2D inputPoint, double tolerance) {
        MultiPathImpl polygonImpl = (MultiPathImpl)polygon._getImpl();
        int res = PointInPolygonHelper.isPointInRing(polygonImpl, iRing, inputPoint, tolerance, null);
        if (res == 0) {
            return PiPResult.PiPOutside;
        }
        if (res == 1) {
            return PiPResult.PiPInside;
        }
        return PiPResult.PiPInside;
    }

    public static PiPResult isPointInAnyOuterRing(Polygon polygon, Point2D inputPoint, double tolerance) {
        int res = PointInPolygonHelper.isPointInAnyOuterRing(polygon, inputPoint, tolerance);
        if (res == 0) {
            return PiPResult.PiPOutside;
        }
        if (res == 1) {
            return PiPResult.PiPInside;
        }
        return PiPResult.PiPInside;
    }

    public static void testPointsInPolygon2D(Polygon polygon, Point2D[] inputPoints, int count, double tolerance, PiPResult[] testResults) {
        if (inputPoints.length < count || testResults.length < count) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < count) {
            testResults[i] = PolygonUtils.isPointInPolygon2D(polygon, inputPoints[i], tolerance);
            ++i;
        }
    }

    static void testPointsInPolygon2D(Polygon polygon, double[] xyStreamBuffer, int pointCount, double tolerance, PiPResult[] testResults) {
        if (xyStreamBuffer.length / 2 < pointCount || testResults.length < pointCount) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < pointCount) {
            testResults[i] = PolygonUtils.isPointInPolygon2D(polygon, xyStreamBuffer[i * 2], xyStreamBuffer[i * 2 + 1], tolerance);
            ++i;
        }
    }

    public static void testPointsInArea2D(Geometry polygon, Point2D[] inputPoints, int count, double tolerance, PiPResult[] testResults) {
        if (polygon.getType() == Geometry.Type.Polygon) {
            PolygonUtils.testPointsInPolygon2D((Polygon)polygon, inputPoints, count, tolerance, testResults);
        } else if (polygon.getType() == Geometry.Type.Envelope) {
            Envelope2D env2D = new Envelope2D();
            ((Envelope)polygon).queryEnvelope2D(env2D);
            PolygonUtils._testPointsInEnvelope2D(env2D, inputPoints, count, tolerance, testResults);
        } else {
            throw new GeometryException("invalid_call");
        }
    }

    public static void testPointsInArea2D(Geometry polygon, double[] xyStreamBuffer, int count, double tolerance, PiPResult[] testResults) {
        if (polygon.getType() == Geometry.Type.Polygon) {
            PolygonUtils.testPointsInPolygon2D((Polygon)polygon, xyStreamBuffer, count, tolerance, testResults);
        } else if (polygon.getType() == Geometry.Type.Envelope) {
            Envelope2D env2D = new Envelope2D();
            ((Envelope)polygon).queryEnvelope2D(env2D);
            PolygonUtils._testPointsInEnvelope2D(env2D, xyStreamBuffer, count, tolerance, testResults);
        } else {
            throw new GeometryException("invalid_call");
        }
    }

    private static void _testPointsInEnvelope2D(Envelope2D env2D, Point2D[] inputPoints, int count, double tolerance, PiPResult[] testResults) {
        if (inputPoints.length < count || testResults.length < count) {
            throw new IllegalArgumentException();
        }
        if (env2D.isEmpty()) {
            int i = 0;
            while (i < count) {
                testResults[i] = PiPResult.PiPOutside;
                ++i;
            }
            return;
        }
        Envelope2D envIn = env2D;
        envIn.inflate(-tolerance * 0.5, -tolerance * 0.5);
        Envelope2D envOut = env2D;
        envOut.inflate(tolerance * 0.5, tolerance * 0.5);
        int i = 0;
        while (i < count) {
            testResults[i] = envIn.contains(inputPoints[i]) ? PiPResult.PiPInside : (!envOut.contains(inputPoints[i]) ? PiPResult.PiPOutside : PiPResult.PiPBoundary);
            ++i;
        }
    }

    private static void _testPointsInEnvelope2D(Envelope2D env2D, double[] xyStreamBuffer, int pointCount, double tolerance, PiPResult[] testResults) {
        if (xyStreamBuffer.length / 2 < pointCount || testResults.length < pointCount) {
            throw new IllegalArgumentException();
        }
        if (env2D.isEmpty()) {
            int i = 0;
            while (i < pointCount) {
                testResults[i] = PiPResult.PiPOutside;
                ++i;
            }
            return;
        }
        Envelope2D envIn = env2D;
        envIn.inflate(-tolerance * 0.5, -tolerance * 0.5);
        Envelope2D envOut = env2D;
        envOut.inflate(tolerance * 0.5, tolerance * 0.5);
        int i = 0;
        while (i < pointCount) {
            testResults[i] = envIn.contains(xyStreamBuffer[i * 2], xyStreamBuffer[i * 2 + 1]) ? PiPResult.PiPInside : (!envIn.contains(xyStreamBuffer[i * 2], xyStreamBuffer[i * 2 + 1]) ? PiPResult.PiPOutside : PiPResult.PiPBoundary);
            ++i;
        }
    }

    static void testPointsOnSegment_(Segment seg, Point2D[] input_points, int count, double tolerance, PiPResult[] test_results) {
        int i = 0;
        while (i < count) {
            test_results[i] = seg.isIntersecting(input_points[i], tolerance) ? PiPResult.PiPBoundary : PiPResult.PiPOutside;
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    static void testPointsOnPolyline2D_(Polyline poly, Point2D[] input_points, int count, double tolerance, PiPResult[] test_results) {
        block10: {
            mp_impl = (MultiPathImpl)poly._getImpl();
            accel = mp_impl._getAccelerators();
            rgeom = null;
            if (accel != null) {
                rgeom = accel.getRasterizedGeometry();
            }
            pointsLeft = count;
            i = 0;
            while (i < count) {
                test_results[i] = PiPResult.PiPInside;
                if (rgeom != null) {
                    input_point = input_points[i];
                    hit = rgeom.queryPointInGeometry(input_point.x, input_point.y);
                    if (hit == RasterizedGeometry2D.HitType.Outside) {
                        test_results[i] = PiPResult.PiPOutside;
                        --pointsLeft;
                    }
                }
                ++i;
            }
            if (pointsLeft == 0) break block10;
            iter = mp_impl.querySegmentIterator();
            ** GOTO lbl31
            {
                segment = iter.nextSegment();
                i = 0;
                while (i < count && pointsLeft != 0) {
                    if (test_results[i] == PiPResult.PiPInside && segment.isIntersecting(input_points[i], tolerance)) {
                        test_results[i] = PiPResult.PiPBoundary;
                        --pointsLeft;
                    }
                    ++i;
                }
                do {
                    if (iter.hasNextSegment() && pointsLeft != 0) continue block1;
lbl31:
                    // 2 sources

                } while (iter.nextPath() && pointsLeft != 0);
            }
        }
        i = 0;
        while (i < count) {
            if (test_results[i] == PiPResult.PiPInside) {
                test_results[i] = PiPResult.PiPOutside;
            }
            ++i;
        }
    }

    static void testPointsOnLine2D(Geometry line, Point2D[] input_points, int count, double tolerance, PiPResult[] test_results) {
        Geometry.Type gt = line.getType();
        if (gt == Geometry.Type.Polyline) {
            PolygonUtils.testPointsOnPolyline2D_((Polyline)line, input_points, count, tolerance, test_results);
        } else if (Geometry.isSegment(gt.value())) {
            PolygonUtils.testPointsOnSegment_((Segment)line, input_points, count, tolerance, test_results);
        } else {
            throw new GeometryException("Invalid call.");
        }
    }

    public static enum PiPResult {
        PiPOutside,
        PiPInside,
        PiPBoundary;

    }
}

