/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.input;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.id.IdType;
import org.apache.hugegraph.computer.core.input.HugeConverter;
import org.apache.hugegraph.structure.graph.Edge;
import org.apache.hugegraph.structure.schema.EdgeLabel;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.SplicingIdGenerator;

public class IdUtil {
    public static final String NUMBER_ID_PREFIX = "L";
    public static final String STRING_ID_PREFIX = "S";

    private static String writeString(Object rawId) {
        Id id = HugeConverter.convertId(rawId);
        String idString = id.toString();
        return (id.idType() == IdType.LONG ? NUMBER_ID_PREFIX : STRING_ID_PREFIX).concat(idString);
    }

    private static List<Object> sortValues(Edge edge, EdgeLabel edgeLabel) {
        List sortKeys = edgeLabel.sortKeys();
        if (sortKeys.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Object> propValues = new ArrayList<Object>(sortKeys.size());
        for (String sk : sortKeys) {
            Object property = edge.property(sk);
            E.checkState((property != null ? 1 : 0) != 0, (String)"The value of sort key '%s' can't be null", (Object[])new Object[]{sk});
            propValues.add(property);
        }
        return propValues;
    }

    public static String assignEdgeId(Edge edge, EdgeLabel edgeLabel) {
        return SplicingIdGenerator.concat((String[])new String[]{IdUtil.writeString(edge.sourceId()), String.valueOf(edgeLabel.id()), SplicingIdGenerator.concatValues(IdUtil.sortValues(edge, edgeLabel)), IdUtil.writeString(edge.targetId())});
    }
}

