/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.input.loader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.config.ComputerOptions;
import org.apache.hugegraph.computer.core.config.Config;
import org.apache.hugegraph.computer.core.input.InputSplit;
import org.apache.hugegraph.computer.core.input.InputSplitFetcher;
import org.apache.hugegraph.computer.core.input.loader.FileInputSplit;
import org.apache.hugegraph.config.TypedOption;
import org.apache.hugegraph.loader.constant.ElemType;
import org.apache.hugegraph.loader.exception.LoadException;
import org.apache.hugegraph.loader.mapping.InputStruct;
import org.apache.hugegraph.loader.mapping.LoadMapping;
import org.apache.hugegraph.loader.source.SourceType;
import org.apache.hugegraph.loader.source.file.FileFilter;
import org.apache.hugegraph.loader.source.file.FileSource;
import org.apache.hugegraph.loader.source.hdfs.HDFSSource;
import org.apache.hugegraph.loader.source.hdfs.KerberosConfig;

public class LoaderFileInputSplitFetcher
implements InputSplitFetcher {
    private final Config config;
    private final List<InputStruct> vertexInputStructs;
    private final List<InputStruct> edgeInputStructs;

    public LoaderFileInputSplitFetcher(Config config) {
        this.config = config;
        String inputStructFile = (String)this.config.get((TypedOption)ComputerOptions.INPUT_LOADER_STRUCT_PATH);
        LoadMapping mapping = LoadMapping.of((String)inputStructFile);
        this.vertexInputStructs = new ArrayList<InputStruct>();
        this.edgeInputStructs = new ArrayList<InputStruct>();
        this.splitStructs(mapping.structs());
    }

    @Override
    public List<InputSplit> fetchVertexInputSplits() {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (InputStruct vertexInputStruct : this.vertexInputStructs) {
            FileSource source = (FileSource)vertexInputStruct.input();
            List<String> paths = this.scanPaths(source);
            if (!CollectionUtils.isNotEmpty(paths)) continue;
            for (String path : paths) {
                FileInputSplit split = new FileInputSplit(ElemType.VERTEX, vertexInputStruct, path);
                splits.add(split);
            }
        }
        return splits;
    }

    @Override
    public List<InputSplit> fetchEdgeInputSplits() {
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        for (InputStruct edgeInputStruct : this.edgeInputStructs) {
            FileSource source = (FileSource)edgeInputStruct.input();
            List<String> paths = this.scanPaths(source);
            if (!CollectionUtils.isNotEmpty(paths)) continue;
            for (String path : paths) {
                FileInputSplit split = new FileInputSplit(ElemType.EDGE, edgeInputStruct, path);
                splits.add(split);
            }
        }
        return splits;
    }

    private void splitStructs(List<InputStruct> structs) {
        InputStruct result;
        for (InputStruct struct : structs) {
            result = struct.extractVertexStruct();
            if (result == InputStruct.EMPTY) continue;
            this.vertexInputStructs.add(result);
        }
        for (InputStruct struct : structs) {
            result = struct.extractEdgeStruct();
            if (result == InputStruct.EMPTY) continue;
            this.edgeInputStructs.add(result);
        }
    }

    private List<String> scanPaths(FileSource source) {
        if (source.type() == SourceType.HDFS) {
            return this.scanHdfsPaths((HDFSSource)source);
        }
        return this.scanLocalPaths(source);
    }

    private List<String> scanLocalPaths(FileSource source) {
        ArrayList<String> paths = new ArrayList<String>();
        File file = FileUtils.getFile((String[])new String[]{source.path()});
        FileFilter filter = source.filter();
        if (file.isFile()) {
            if (!filter.reserved(file.getName())) {
                throw new LoadException("Please check file name and extensions, ensure that at least one file is available for reading");
            }
            paths.add(file.getAbsolutePath());
        } else {
            assert (file.isDirectory());
            File[] subFiles = file.listFiles();
            if (subFiles == null) {
                throw new LoadException("Error while listing the files of path '%s'", new Object[]{file});
            }
            for (File subFile : subFiles) {
                if (!filter.reserved(subFile.getName())) continue;
                paths.add(subFile.getAbsolutePath());
            }
        }
        return paths;
    }

    private List<String> scanHdfsPaths(HDFSSource hdfsSource) {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            Configuration configuration = this.loadConfiguration(hdfsSource);
            this.enableKerberos(hdfsSource, configuration);
            try (FileSystem hdfs = FileSystem.get((Configuration)configuration);){
                Path path = new Path(hdfsSource.path());
                FileFilter filter = hdfsSource.filter();
                if (hdfs.getFileStatus(path).isFile()) {
                    if (!filter.reserved(path.getName())) {
                        throw new ComputerException("Please check path name and extensions, ensure that at least one path is available for reading");
                    }
                    paths.add(path.toString());
                } else {
                    Path[] subPaths;
                    assert (hdfs.getFileStatus(path).isDirectory());
                    FileStatus[] statuses = hdfs.listStatus(path);
                    for (Path subPath : subPaths = FileUtil.stat2Paths((FileStatus[])statuses)) {
                        if (!filter.reserved(subPath.getName())) continue;
                        paths.add(subPath.toString());
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throw new ComputerException("Failed to scanPaths", throwable);
        }
        return paths;
    }

    private Configuration loadConfiguration(HDFSSource source) {
        Configuration conf = new Configuration();
        conf.addResource(new Path(source.coreSitePath()));
        if (source.hdfsSitePath() != null) {
            conf.addResource(new Path(source.hdfsSitePath()));
        }
        return conf;
    }

    private void enableKerberos(HDFSSource source, Configuration conf) throws IOException {
        KerberosConfig kerberosConfig = source.kerberosConfig();
        if (kerberosConfig != null && kerberosConfig.enable()) {
            System.setProperty("java.security.krb5.conf", kerberosConfig.krb5Conf());
            UserGroupInformation.setConfiguration((Configuration)conf);
            UserGroupInformation.loginUserFromKeytab((String)kerberosConfig.principal(), (String)kerberosConfig.keyTab());
        }
    }

    @Override
    public void close() {
    }
}

