/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.fixed;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.set.fixed.AbstractMemoryEfficientMutableSet;
import org.eclipse.collections.impl.set.fixed.DoubletonSet;
import org.eclipse.collections.impl.set.fixed.EmptySet;

class SingletonSet<T>
extends AbstractMemoryEfficientMutableSet<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private T element1;

    SingletonSet(T obj1) {
        this.element1 = obj1;
    }

    public SingletonSet() {
    }

    public int size() {
        return 1;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Collection collection = (Collection)o;
        return collection.size() == this.size() && collection.contains(this.element1);
    }

    public int hashCode() {
        return this.nullSafeHashCode(this.element1);
    }

    @Override
    public SingletonSet<T> clone() {
        return new SingletonSet<T>(this.element1);
    }

    @Override
    public boolean contains(Object obj) {
        return Objects.equals(obj, this.element1);
    }

    public Iterator<T> iterator() {
        return new SingletonSetIterator();
    }

    public T getFirst() {
        return this.element1;
    }

    public T getLast() {
        return this.element1;
    }

    public T getOnly() {
        return this.element1;
    }

    public void each(Procedure<? super T> procedure) {
        procedure.value(this.element1);
    }

    @Override
    public void forEachWithIndex(ObjectIntProcedure<? super T> objectIntProcedure) {
        objectIntProcedure.value(this.element1, 0);
    }

    @Override
    public <P> void forEachWith(Procedure2<? super T, ? super P> procedure, P parameter) {
        procedure.value(this.element1, parameter);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.element1);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.element1 = in.readObject();
    }

    public MutableSet<T> with(T element) {
        return this.contains(element) ? this : new DoubletonSet<T>(this.element1, element);
    }

    public MutableSet<T> without(T element) {
        if (Objects.equals(element, this.element1)) {
            return new EmptySet();
        }
        return this;
    }

    private class SingletonSetIterator
    extends AbstractMemoryEfficientMutableSet.MemoryEfficientSetIterator {
        private SingletonSetIterator() {
        }

        @Override
        protected T getElement(int i) {
            if (i == 0) {
                return SingletonSet.this.element1;
            }
            throw new NoSuchElementException("i=" + i);
        }
    }
}

