/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.sstable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Downsampling {
    public static final int BASE_SAMPLING_LEVEL = 128;
    private static final Map<Integer, List<Integer>> samplePatternCache = new HashMap<Integer, List<Integer>>();
    private static final Map<Integer, List<Integer>> originalIndexCache = new HashMap<Integer, List<Integer>>();

    public static List<Integer> getSamplingPattern(int samplingLevel) {
        int i;
        List<Integer> pattern = samplePatternCache.get(samplingLevel);
        if (pattern != null) {
            return pattern;
        }
        if (samplingLevel <= 1) {
            return Arrays.asList(0);
        }
        int[] odds = new int[samplingLevel / 2];
        int[] evens = new int[samplingLevel / 2];
        for (i = 1; i < samplingLevel; i += 2) {
            odds[i / 2] = i;
        }
        for (i = 0; i < samplingLevel; i += 2) {
            evens[i / 2] = i;
        }
        List<Integer> ordering = Downsampling.getSamplingPattern(samplingLevel / 2);
        ArrayList<Integer> startIndices = new ArrayList<Integer>(samplingLevel);
        for (Integer index : ordering) {
            startIndices.add(odds[index]);
        }
        for (Integer index : ordering) {
            startIndices.add(evens[index]);
        }
        samplePatternCache.put(samplingLevel, startIndices);
        return startIndices;
    }

    public static List<Integer> getOriginalIndexes(int samplingLevel) {
        List<Integer> originalIndexes = originalIndexCache.get(samplingLevel);
        if (originalIndexes != null) {
            return originalIndexes;
        }
        List<Integer> pattern = Downsampling.getSamplingPattern(128).subList(0, 128 - samplingLevel);
        originalIndexes = new ArrayList<Integer>(samplingLevel);
        for (int j = 0; j < 128; ++j) {
            if (pattern.contains(j)) continue;
            originalIndexes.add(j);
        }
        originalIndexCache.put(samplingLevel, originalIndexes);
        return originalIndexes;
    }

    public static int getEffectiveIndexIntervalAfterIndex(int index, int samplingLevel, int minIndexInterval) {
        assert (index >= 0);
        List<Integer> originalIndexes = Downsampling.getOriginalIndexes(samplingLevel);
        int nextEntryOriginalIndex = (index %= samplingLevel) == originalIndexes.size() - 1 ? 128 : originalIndexes.get(index + 1);
        return (nextEntryOriginalIndex - originalIndexes.get(index)) * minIndexInterval;
    }

    public static int[] getStartPoints(int currentSamplingLevel, int newSamplingLevel) {
        List<Integer> allStartPoints = Downsampling.getSamplingPattern(128);
        int initialRound = 128 - currentSamplingLevel;
        int numRounds = Math.abs(currentSamplingLevel - newSamplingLevel);
        int[] startPoints = new int[numRounds];
        for (int i = 0; i < numRounds; ++i) {
            int start = allStartPoints.get(initialRound + i);
            int adjustment = 0;
            for (int j = 0; j < initialRound; ++j) {
                if (allStartPoints.get(j) >= start) continue;
                ++adjustment;
            }
            startPoints[i] = start - adjustment;
        }
        return startPoints;
    }
}

