/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.io.util;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.cassandra.io.compress.BufferType;

public class SequentialWriterOption {
    public static final SequentialWriterOption DEFAULT = SequentialWriterOption.newBuilder().build();
    private final int bufferSize;
    private final BufferType bufferType;
    private final boolean trickleFsync;
    private final int trickleFsyncByteInterval;
    private final boolean finishOnClose;

    private SequentialWriterOption(int bufferSize, BufferType bufferType, boolean trickleFsync, int trickleFsyncByteInterval, boolean finishOnClose) {
        this.bufferSize = bufferSize;
        this.bufferType = bufferType;
        this.trickleFsync = trickleFsync;
        this.trickleFsyncByteInterval = trickleFsyncByteInterval;
        this.finishOnClose = finishOnClose;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int bufferSize() {
        return this.bufferSize;
    }

    public BufferType bufferType() {
        return this.bufferType;
    }

    public boolean trickleFsync() {
        return this.trickleFsync;
    }

    public int trickleFsyncByteInterval() {
        return this.trickleFsyncByteInterval;
    }

    public boolean finishOnClose() {
        return this.finishOnClose;
    }

    public ByteBuffer allocateBuffer() {
        return this.bufferType.allocate(this.bufferSize);
    }

    public static class Builder {
        private int bufferSize = 65536;
        private BufferType bufferType = BufferType.ON_HEAP;
        private boolean trickleFsync = false;
        private int trickleFsyncByteInterval = 0xA00000;
        private boolean finishOnClose = false;

        private Builder() {
        }

        public SequentialWriterOption build() {
            return new SequentialWriterOption(this.bufferSize, this.bufferType, this.trickleFsync, this.trickleFsyncByteInterval, this.finishOnClose);
        }

        public Builder bufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public Builder bufferType(BufferType bufferType) {
            this.bufferType = Objects.requireNonNull(bufferType);
            return this;
        }

        public Builder trickleFsync(boolean trickleFsync) {
            this.trickleFsync = trickleFsync;
            return this;
        }

        public Builder trickleFsyncByteInterval(int trickleFsyncByteInterval) {
            this.trickleFsyncByteInterval = trickleFsyncByteInterval;
            return this;
        }

        public Builder finishOnClose(boolean finishOnClose) {
            this.finishOnClose = finishOnClose;
            return this;
        }
    }
}

