/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.backend.store.cassandra;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.DriverException;
import com.datastax.driver.core.querybuilder.BuiltStatement;
import com.datastax.driver.core.querybuilder.Clause;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.datastax.driver.core.querybuilder.Using;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hugegraph.backend.BackendException;
import org.apache.hugegraph.backend.id.EdgeId;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.backend.id.IdUtil;
import org.apache.hugegraph.backend.query.Query;
import org.apache.hugegraph.backend.serializer.TableBackendEntry;
import org.apache.hugegraph.backend.store.BackendEntry;
import org.apache.hugegraph.backend.store.cassandra.CassandraBackendEntry;
import org.apache.hugegraph.backend.store.cassandra.CassandraEntryIterator;
import org.apache.hugegraph.backend.store.cassandra.CassandraSessionPool;
import org.apache.hugegraph.backend.store.cassandra.CassandraTable;
import org.apache.hugegraph.type.HugeType;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.type.define.HugeKeys;
import org.apache.hugegraph.util.E;

public class CassandraTables {
    public static final String LABEL_INDEX = "label_index";
    public static final String NAME_INDEX = "name_index";
    private static final DataType TYPE_PK = DataType.cint();
    private static final DataType TYPE_SL = DataType.cint();
    private static final DataType TYPE_IL = DataType.cint();
    private static final DataType TYPE_UD = DataType.map((DataType)DataType.text(), (DataType)DataType.text());
    private static final DataType TYPE_ID = DataType.blob();
    private static final DataType TYPE_PROP = DataType.blob();
    private static final DataType TYPE_TTL = DataType.bigint();
    private static final DataType TYPE_EXPIRED_TIME = DataType.bigint();
    private static final long COMMIT_DELETE_BATCH = 500L;

    private static Statement setTtl(BuiltStatement statement, TableBackendEntry.Row entry) {
        long ttl = entry.ttl();
        if (ttl != 0L) {
            int calcTtl = (int)Math.ceil((double)ttl / 1000.0);
            Using usingTtl = QueryBuilder.ttl((int)calcTtl);
            if (statement instanceof Insert) {
                ((Insert)statement).using(usingTtl);
            } else {
                assert (statement instanceof Update);
                ((Update)statement).using(usingTtl);
            }
        }
        return statement;
    }

    public static class OlapRangeDoubleIndex
    extends RangeDoubleIndex {
        public static final String TABLE = HugeType.OLAP.string();

        public OlapRangeDoubleIndex(String store) {
            this(store, TABLE);
        }

        protected OlapRangeDoubleIndex(String store, String table) {
            super(OlapRangeDoubleIndex.joinTableName((String)store, (String)table));
        }
    }

    public static class OlapRangeFloatIndex
    extends RangeFloatIndex {
        public static final String TABLE = HugeType.OLAP.string();

        public OlapRangeFloatIndex(String store) {
            this(store, TABLE);
        }

        protected OlapRangeFloatIndex(String store, String table) {
            super(OlapRangeFloatIndex.joinTableName((String)store, (String)table));
        }
    }

    public static class OlapRangeLongIndex
    extends RangeLongIndex {
        public static final String TABLE = HugeType.OLAP.string();

        public OlapRangeLongIndex(String store) {
            this(store, TABLE);
        }

        protected OlapRangeLongIndex(String store, String table) {
            super(OlapRangeLongIndex.joinTableName((String)store, (String)table));
        }
    }

    public static class OlapRangeIntIndex
    extends RangeIntIndex {
        public static final String TABLE = HugeType.OLAP.string();

        public OlapRangeIntIndex(String store) {
            this(store, TABLE);
        }

        protected OlapRangeIntIndex(String store, String table) {
            super(OlapRangeIntIndex.joinTableName((String)store, (String)table));
        }
    }

    public static class OlapSecondaryIndex
    extends SecondaryIndex {
        public static final String TABLE = HugeType.OLAP.string();

        public OlapSecondaryIndex(String store) {
            this(store, TABLE);
        }

        protected OlapSecondaryIndex(String store, String table) {
            super(OlapSecondaryIndex.joinTableName((String)store, (String)table));
        }
    }

    public static class Olap
    extends CassandraTable {
        public static final String TABLE = HugeType.OLAP.string();
        private Id pkId;

        public Olap(String store, Id id) {
            super(Olap.joinTableName((String)store, (String)Olap.joinTableName((String)TABLE, (String)id.asString())));
            this.pkId = id;
        }

        public void init(CassandraSessionPool.Session session) {
            ImmutableMap pkeys = ImmutableMap.of((Object)HugeKeys.ID, (Object)TYPE_ID);
            ImmutableMap ckeys = ImmutableMap.of();
            ImmutableMap columns = ImmutableMap.of((Object)HugeKeys.PROPERTY_VALUE, (Object)TYPE_PROP);
            this.createTable(session, (ImmutableMap<HugeKeys, DataType>)pkeys, (ImmutableMap<HugeKeys, DataType>)ckeys, (ImmutableMap<HugeKeys, DataType>)columns);
        }

        @Override
        protected Iterator<BackendEntry> results2Entries(Query q, ResultSet r) {
            return new CassandraEntryIterator(r, q, (e1, row) -> {
                CassandraBackendEntry e2 = Olap.row2Entry(q.resultType(), row);
                e2.subId(this.pkId);
                return this.mergeEntries((BackendEntry)e1, (BackendEntry)e2);
            });
        }

        @Override
        public boolean isOlap() {
            return true;
        }
    }

    public static class ShardIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.SHARD_INDEX.string();

        public ShardIndex(String store) {
            super(store, TABLE);
        }

        @Override
        protected DataType fieldValuesType() {
            return DataType.text();
        }

        @Override
        public void insert(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            throw new BackendException("ShardIndex insertion is not supported.");
        }
    }

    public static class RangeDoubleIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_DOUBLE_INDEX.string();

        public RangeDoubleIndex(String store) {
            super(store, TABLE);
        }

        @Override
        protected DataType fieldValuesType() {
            return DataType.cdouble();
        }
    }

    public static class RangeLongIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_LONG_INDEX.string();

        public RangeLongIndex(String store) {
            super(store, TABLE);
        }

        @Override
        protected DataType fieldValuesType() {
            return DataType.bigint();
        }
    }

    public static class RangeFloatIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_FLOAT_INDEX.string();

        public RangeFloatIndex(String store) {
            super(store, TABLE);
        }

        @Override
        protected DataType fieldValuesType() {
            return DataType.cfloat();
        }
    }

    public static class RangeIntIndex
    extends RangeIndex {
        public static final String TABLE = HugeType.RANGE_INT_INDEX.string();

        public RangeIntIndex(String store) {
            super(store, TABLE);
        }

        @Override
        protected DataType fieldValuesType() {
            return DataType.cint();
        }
    }

    public static abstract class RangeIndex
    extends CassandraTable {
        protected RangeIndex(String store, String table) {
            super(RangeIndex.joinTableName((String)store, (String)table));
        }

        public void init(CassandraSessionPool.Session session) {
            ImmutableMap pkeys = ImmutableMap.of((Object)HugeKeys.INDEX_LABEL_ID, (Object)TYPE_IL);
            ImmutableMap ckeys = ImmutableMap.of((Object)HugeKeys.FIELD_VALUES, (Object)this.fieldValuesType(), (Object)HugeKeys.ELEMENT_IDS, (Object)TYPE_ID);
            ImmutableMap columns = ImmutableMap.of((Object)HugeKeys.EXPIRED_TIME, (Object)TYPE_EXPIRED_TIME);
            this.createTable(session, (ImmutableMap<HugeKeys, DataType>)pkeys, (ImmutableMap<HugeKeys, DataType>)ckeys, (ImmutableMap<HugeKeys, DataType>)columns);
        }

        protected DataType fieldValuesType() {
            return DataType.decimal();
        }

        @Override
        protected List<HugeKeys> idColumnName() {
            return ImmutableList.of((Object)HugeKeys.INDEX_LABEL_ID, (Object)HugeKeys.FIELD_VALUES, (Object)HugeKeys.ELEMENT_IDS);
        }

        @Override
        protected List<HugeKeys> modifiableColumnName() {
            return ImmutableList.of();
        }

        @Override
        public void delete(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            Object fieldValues = entry.column(HugeKeys.FIELD_VALUES);
            if (fieldValues != null) {
                super.delete(session, entry);
                return;
            }
            Long indexLabel = (Long)entry.column(HugeKeys.INDEX_LABEL_ID);
            if (indexLabel == null) {
                throw new BackendException("Range index deletion needs INDEX_LABEL_ID, but not provided.");
            }
            Delete delete = QueryBuilder.delete().from(this.table());
            delete.where(RangeIndex.formatEQ(HugeKeys.INDEX_LABEL_ID, indexLabel));
            session.add((Statement)delete);
        }

        @Override
        public void insert(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            throw new BackendException("RangeIndex insertion is not supported.");
        }

        @Override
        public void append(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            assert (entry.columns().size() == 3 || entry.columns().size() == 4);
            Insert insert = this.buildInsert(entry);
            session.add(CassandraTables.setTtl((BuiltStatement)insert, entry));
        }

        @Override
        public void eliminate(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            assert (entry.columns().size() == 3 || entry.columns().size() == 4);
            this.delete(session, entry);
        }
    }

    public static class UniqueIndex
    extends SecondaryIndex {
        public static final String TABLE = HugeType.UNIQUE_INDEX.string();

        public UniqueIndex(String store) {
            super(store, TABLE);
        }

        @Override
        public void insert(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            throw new BackendException("UniqueIndex insertion is not supported.");
        }
    }

    public static class SearchIndex
    extends SecondaryIndex {
        public static final String TABLE = HugeType.SEARCH_INDEX.string();

        public SearchIndex(String store) {
            super(store, TABLE);
        }

        @Override
        public void insert(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            throw new BackendException("SearchIndex insertion is not supported.");
        }
    }

    public static class SecondaryIndex
    extends CassandraTable {
        public static final String TABLE = HugeType.SECONDARY_INDEX.string();

        public SecondaryIndex(String store) {
            this(store, TABLE);
        }

        protected SecondaryIndex(String store, String table) {
            super(SecondaryIndex.joinTableName((String)store, (String)table));
        }

        public void init(CassandraSessionPool.Session session) {
            ImmutableMap pkeys = ImmutableMap.of((Object)HugeKeys.FIELD_VALUES, (Object)DataType.text());
            ImmutableMap ckeys = ImmutableMap.of((Object)HugeKeys.INDEX_LABEL_ID, (Object)TYPE_IL, (Object)HugeKeys.ELEMENT_IDS, (Object)TYPE_ID);
            ImmutableMap columns = ImmutableMap.of((Object)HugeKeys.EXPIRED_TIME, (Object)TYPE_EXPIRED_TIME);
            this.createTable(session, (ImmutableMap<HugeKeys, DataType>)pkeys, (ImmutableMap<HugeKeys, DataType>)ckeys, (ImmutableMap<HugeKeys, DataType>)columns);
        }

        @Override
        protected List<HugeKeys> idColumnName() {
            return ImmutableList.of((Object)HugeKeys.FIELD_VALUES, (Object)HugeKeys.INDEX_LABEL_ID, (Object)HugeKeys.ELEMENT_IDS);
        }

        @Override
        protected List<HugeKeys> modifiableColumnName() {
            return ImmutableList.of();
        }

        @Override
        public void delete(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            ResultSet rs;
            String fieldValues = (String)entry.column(HugeKeys.FIELD_VALUES);
            if (fieldValues != null) {
                super.delete(session, entry);
                return;
            }
            Long indexLabel = (Long)entry.column(HugeKeys.INDEX_LABEL_ID);
            if (indexLabel == null) {
                throw new BackendException("SecondaryIndex deletion needs INDEX_LABEL_ID, but not provided.");
            }
            Select select = QueryBuilder.select().from(this.table());
            select.where(SecondaryIndex.formatEQ(HugeKeys.INDEX_LABEL_ID, indexLabel));
            select.allowFiltering();
            try {
                rs = session.execute((Statement)select);
            }
            catch (DriverException e) {
                throw new BackendException("Failed to query secondary indexes with index label id '%s' for deleting", new Object[]{indexLabel, e});
            }
            String FIELD_VALUES = SecondaryIndex.formatKey(HugeKeys.FIELD_VALUES);
            long count = 0L;
            for (Row r : rs) {
                fieldValues = (String)r.get(FIELD_VALUES, String.class);
                Delete delete = QueryBuilder.delete().from(this.table());
                delete.where(SecondaryIndex.formatEQ(HugeKeys.INDEX_LABEL_ID, indexLabel));
                delete.where(SecondaryIndex.formatEQ(HugeKeys.FIELD_VALUES, fieldValues));
                session.add((Statement)delete);
                if (++count < 500L) continue;
                session.commit();
                count = 0L;
            }
        }

        @Override
        public void insert(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            throw new BackendException("SecondaryIndex insertion is not supported.");
        }

        @Override
        public void append(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            assert (entry.columns().size() == 3 || entry.columns().size() == 4);
            Insert insert = this.buildInsert(entry);
            session.add(CassandraTables.setTtl((BuiltStatement)insert, entry));
        }

        @Override
        public void eliminate(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            assert (entry.columns().size() == 3 || entry.columns().size() == 4);
            this.delete(session, entry);
        }
    }

    public static class Edge
    extends CassandraTable {
        public static final String TABLE_SUFFIX = HugeType.EDGE.string();
        private final String store;
        private final Directions direction;

        protected Edge(String store, Directions direction) {
            super(Edge.joinTableName((String)store, (String)Edge.table(direction)));
            this.store = store;
            this.direction = direction;
        }

        protected String edgesTable(Directions direction) {
            return Edge.joinTableName((String)this.store, (String)Edge.table(direction));
        }

        protected Directions direction() {
            return this.direction;
        }

        protected String labelIndexTable() {
            return this.table();
        }

        public void init(CassandraSessionPool.Session session) {
            ImmutableMap pkeys = ImmutableMap.of((Object)HugeKeys.OWNER_VERTEX, (Object)TYPE_ID);
            ImmutableMap ckeys = ImmutableMap.of((Object)HugeKeys.DIRECTION, (Object)DataType.tinyint(), (Object)HugeKeys.LABEL, (Object)TYPE_SL, (Object)HugeKeys.SORT_VALUES, (Object)DataType.text(), (Object)HugeKeys.OTHER_VERTEX, (Object)TYPE_ID);
            ImmutableMap columns = ImmutableMap.of((Object)HugeKeys.PROPERTIES, (Object)DataType.map((DataType)TYPE_PK, (DataType)TYPE_PROP), (Object)HugeKeys.EXPIRED_TIME, (Object)TYPE_EXPIRED_TIME);
            this.createTable(session, (ImmutableMap<HugeKeys, DataType>)pkeys, (ImmutableMap<HugeKeys, DataType>)ckeys, (ImmutableMap<HugeKeys, DataType>)columns);
            if (this.direction == Directions.OUT) {
                this.createIndex(session, CassandraTables.LABEL_INDEX, HugeKeys.LABEL);
            }
        }

        @Override
        public void insert(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            Insert insert = this.buildInsert(entry);
            session.add(CassandraTables.setTtl((BuiltStatement)insert, entry));
        }

        @Override
        public void append(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            Update update = this.buildAppend(entry);
            session.add(CassandraTables.setTtl((BuiltStatement)update, entry));
        }

        @Override
        protected List<HugeKeys> pkColumnName() {
            return ImmutableList.of((Object)HugeKeys.OWNER_VERTEX);
        }

        @Override
        protected List<HugeKeys> idColumnName() {
            return Arrays.asList(EdgeId.KEYS);
        }

        @Override
        protected List<Object> idColumnValue(Id id) {
            EdgeId edgeId;
            if (id instanceof EdgeId) {
                edgeId = (EdgeId)id;
            } else {
                String[] idParts = EdgeId.split((Id)id);
                if (idParts.length == 1) {
                    return Arrays.asList(idParts);
                }
                id = IdUtil.readString((String)id.asString());
                edgeId = EdgeId.parse((String)id.asString());
            }
            E.checkState((edgeId.direction() == this.direction ? 1 : 0) != 0, (String)"Can't query %s edges from %s edges table", (Object[])new Object[]{edgeId.direction(), this.direction});
            return this.idColumnValue(edgeId);
        }

        protected final List<Object> idColumnValue(EdgeId edgeId) {
            ArrayList<Object> list = new ArrayList<Object>(5);
            list.add(IdUtil.writeBinString((Id)edgeId.ownerVertexId()));
            list.add(edgeId.directionCode());
            list.add(edgeId.edgeLabelId().asLong());
            list.add(edgeId.sortValues());
            list.add(IdUtil.writeBinString((Id)edgeId.otherVertexId()));
            return list;
        }

        @Override
        public void delete(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            List<Object> idParts = this.idColumnValue(entry.id());
            if (idParts.size() > 1 || !entry.columns().isEmpty()) {
                super.delete(session, entry);
                return;
            }
            this.deleteEdgesByLabel(session, entry.id());
        }

        protected void deleteEdgesByLabel(CassandraSessionPool.Session session, Id label) {
            ResultSet rs;
            if (this.direction == Directions.IN) {
                return;
            }
            String OWNER_VERTEX = Edge.formatKey(HugeKeys.OWNER_VERTEX);
            String SORT_VALUES = Edge.formatKey(HugeKeys.SORT_VALUES);
            String OTHER_VERTEX = Edge.formatKey(HugeKeys.OTHER_VERTEX);
            Select select = QueryBuilder.select().from(this.labelIndexTable());
            select.where(Edge.formatEQ(HugeKeys.LABEL, label.asLong()));
            try {
                rs = session.execute((Statement)select);
            }
            catch (DriverException e) {
                throw new BackendException("Failed to query edges with label '%s' for deleting", (Throwable)e, new Object[]{label});
            }
            long count = 0L;
            for (Row row : rs) {
                Object ownerVertex = row.getObject(OWNER_VERTEX);
                Object sortValues = row.getObject(SORT_VALUES);
                Object otherVertex = row.getObject(OTHER_VERTEX);
                session.add((Statement)this.buildDelete(label, ownerVertex, Directions.OUT, sortValues, otherVertex));
                session.add((Statement)this.buildDelete(label, otherVertex, Directions.IN, sortValues, ownerVertex));
                if ((count += 2L) < 500L) continue;
                session.commit();
                count = 0L;
            }
            if (count > 0L) {
                session.commit();
            }
        }

        private Delete buildDelete(Id label, Object ownerVertex, Directions direction, Object sortValues, Object otherVertex) {
            Delete delete = QueryBuilder.delete().from(this.edgesTable(direction));
            delete.where(Edge.formatEQ(HugeKeys.OWNER_VERTEX, ownerVertex));
            delete.where(Edge.formatEQ(HugeKeys.DIRECTION, EdgeId.directionToCode((Directions)direction)));
            delete.where(Edge.formatEQ(HugeKeys.LABEL, label.asLong()));
            delete.where(Edge.formatEQ(HugeKeys.SORT_VALUES, sortValues));
            delete.where(Edge.formatEQ(HugeKeys.OTHER_VERTEX, otherVertex));
            return delete;
        }

        @Override
        protected BackendEntry mergeEntries(BackendEntry e1, BackendEntry e2) {
            CassandraBackendEntry current = (CassandraBackendEntry)e1;
            CassandraBackendEntry next = (CassandraBackendEntry)e2;
            E.checkState((current == null || current.type().isVertex() ? 1 : 0) != 0, (String)"The current entry must be null or VERTEX", (Object[])new Object[0]);
            E.checkState((next != null && next.type().isEdge() ? 1 : 0) != 0, (String)"The next entry must be EDGE", (Object[])new Object[0]);
            long maxSize = 500L;
            if (current != null && (long)current.subRows().size() < maxSize) {
                Object nextVertexId = next.column(HugeKeys.OWNER_VERTEX);
                if (current.id().equals(IdGenerator.of((Object)nextVertexId))) {
                    current.subRow(next.row());
                    return current;
                }
            }
            return this.wrapByVertex(next);
        }

        private CassandraBackendEntry wrapByVertex(CassandraBackendEntry edge) {
            assert (edge.type().isEdge());
            Object ownerVertex = edge.column(HugeKeys.OWNER_VERTEX);
            E.checkState((ownerVertex != null ? 1 : 0) != 0, (String)"Invalid backend entry", (Object[])new Object[0]);
            Id vertexId = IdGenerator.of((Object)ownerVertex);
            CassandraBackendEntry vertex = new CassandraBackendEntry(HugeType.VERTEX, vertexId);
            vertex.column(HugeKeys.ID, ownerVertex);
            vertex.column(HugeKeys.PROPERTIES, ImmutableMap.of());
            vertex.subRow(edge.row());
            return vertex;
        }

        private static String table(Directions direction) {
            assert (direction == Directions.OUT || direction == Directions.IN);
            return direction.type().string() + TABLE_SUFFIX;
        }

        public static CassandraTable out(String store) {
            return new Edge(store, Directions.OUT);
        }

        public static CassandraTable in(String store) {
            return new Edge(store, Directions.IN);
        }
    }

    public static class Vertex
    extends CassandraTable {
        public static final String TABLE = HugeType.VERTEX.string();

        public Vertex(String store) {
            super(Vertex.joinTableName((String)store, (String)TABLE));
        }

        public void init(CassandraSessionPool.Session session) {
            ImmutableMap pkeys = ImmutableMap.of((Object)HugeKeys.ID, (Object)TYPE_ID);
            ImmutableMap ckeys = ImmutableMap.of();
            ImmutableMap columns = ImmutableMap.of((Object)HugeKeys.LABEL, (Object)TYPE_SL, (Object)HugeKeys.PROPERTIES, (Object)DataType.map((DataType)TYPE_PK, (DataType)TYPE_PROP), (Object)HugeKeys.EXPIRED_TIME, (Object)TYPE_EXPIRED_TIME);
            this.createTable(session, (ImmutableMap<HugeKeys, DataType>)pkeys, (ImmutableMap<HugeKeys, DataType>)ckeys, (ImmutableMap<HugeKeys, DataType>)columns);
            this.createIndex(session, CassandraTables.LABEL_INDEX, HugeKeys.LABEL);
        }

        @Override
        public void insert(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            Insert insert = this.buildInsert(entry);
            session.add(CassandraTables.setTtl((BuiltStatement)insert, entry));
        }

        @Override
        public void append(CassandraSessionPool.Session session, TableBackendEntry.Row entry) {
            Update append = this.buildAppend(entry);
            session.add(CassandraTables.setTtl((BuiltStatement)append, entry));
        }
    }

    public static class IndexLabel
    extends CassandraTable {
        public static final String TABLE = HugeType.INDEX_LABEL.string();

        public IndexLabel() {
            super(TABLE);
        }

        public void init(CassandraSessionPool.Session session) {
            ImmutableMap pkeys = ImmutableMap.of((Object)HugeKeys.ID, (Object)TYPE_IL);
            ImmutableMap ckeys = ImmutableMap.of();
            ImmutableMap columns = ImmutableMap.builder().put((Object)HugeKeys.NAME, (Object)DataType.text()).put((Object)HugeKeys.BASE_TYPE, (Object)DataType.tinyint()).put((Object)HugeKeys.BASE_VALUE, (Object)TYPE_SL).put((Object)HugeKeys.INDEX_TYPE, (Object)DataType.tinyint()).put((Object)HugeKeys.FIELDS, (Object)DataType.list((DataType)TYPE_PK)).put((Object)HugeKeys.USER_DATA, (Object)TYPE_UD).put((Object)HugeKeys.STATUS, (Object)DataType.tinyint()).build();
            this.createTable(session, (ImmutableMap<HugeKeys, DataType>)pkeys, (ImmutableMap<HugeKeys, DataType>)ckeys, (ImmutableMap<HugeKeys, DataType>)columns);
            this.createIndex(session, CassandraTables.NAME_INDEX, HugeKeys.NAME);
        }
    }

    public static class PropertyKey
    extends CassandraTable {
        public static final String TABLE = HugeType.PROPERTY_KEY.string();

        public PropertyKey() {
            super(TABLE);
        }

        public void init(CassandraSessionPool.Session session) {
            ImmutableMap pkeys = ImmutableMap.of((Object)HugeKeys.ID, (Object)DataType.cint());
            ImmutableMap ckeys = ImmutableMap.of();
            ImmutableMap columns = ImmutableMap.builder().put((Object)HugeKeys.NAME, (Object)DataType.text()).put((Object)HugeKeys.DATA_TYPE, (Object)DataType.tinyint()).put((Object)HugeKeys.CARDINALITY, (Object)DataType.tinyint()).put((Object)HugeKeys.AGGREGATE_TYPE, (Object)DataType.tinyint()).put((Object)HugeKeys.WRITE_TYPE, (Object)DataType.tinyint()).put((Object)HugeKeys.PROPERTIES, (Object)DataType.set((DataType)TYPE_PK)).put((Object)HugeKeys.USER_DATA, (Object)TYPE_UD).put((Object)HugeKeys.STATUS, (Object)DataType.tinyint()).build();
            this.createTable(session, (ImmutableMap<HugeKeys, DataType>)pkeys, (ImmutableMap<HugeKeys, DataType>)ckeys, (ImmutableMap<HugeKeys, DataType>)columns);
            this.createIndex(session, CassandraTables.NAME_INDEX, HugeKeys.NAME);
        }
    }

    public static class EdgeLabel
    extends CassandraTable {
        public static final String TABLE = HugeType.EDGE_LABEL.string();

        public EdgeLabel() {
            super(TABLE);
        }

        public void init(CassandraSessionPool.Session session) {
            ImmutableMap pkeys = ImmutableMap.of((Object)HugeKeys.ID, (Object)TYPE_SL);
            ImmutableMap ckeys = ImmutableMap.of();
            ImmutableMap columns = ImmutableMap.builder().put((Object)HugeKeys.NAME, (Object)DataType.text()).put((Object)HugeKeys.FREQUENCY, (Object)DataType.tinyint()).put((Object)HugeKeys.SOURCE_LABEL, (Object)TYPE_SL).put((Object)HugeKeys.TARGET_LABEL, (Object)TYPE_SL).put((Object)HugeKeys.SORT_KEYS, (Object)DataType.list((DataType)TYPE_PK)).put((Object)HugeKeys.NULLABLE_KEYS, (Object)DataType.set((DataType)TYPE_PK)).put((Object)HugeKeys.INDEX_LABELS, (Object)DataType.set((DataType)TYPE_IL)).put((Object)HugeKeys.PROPERTIES, (Object)DataType.set((DataType)TYPE_PK)).put((Object)HugeKeys.ENABLE_LABEL_INDEX, (Object)DataType.cboolean()).put((Object)HugeKeys.USER_DATA, (Object)TYPE_UD).put((Object)HugeKeys.STATUS, (Object)DataType.tinyint()).put((Object)HugeKeys.TTL, (Object)TYPE_TTL).put((Object)HugeKeys.TTL_START_TIME, (Object)TYPE_PK).build();
            this.createTable(session, (ImmutableMap<HugeKeys, DataType>)pkeys, (ImmutableMap<HugeKeys, DataType>)ckeys, (ImmutableMap<HugeKeys, DataType>)columns);
            this.createIndex(session, CassandraTables.NAME_INDEX, HugeKeys.NAME);
        }
    }

    public static class VertexLabel
    extends CassandraTable {
        public static final String TABLE = HugeType.VERTEX_LABEL.string();

        public VertexLabel() {
            super(TABLE);
        }

        public void init(CassandraSessionPool.Session session) {
            ImmutableMap pkeys = ImmutableMap.of((Object)HugeKeys.ID, (Object)TYPE_SL);
            ImmutableMap ckeys = ImmutableMap.of();
            ImmutableMap columns = ImmutableMap.builder().put((Object)HugeKeys.NAME, (Object)DataType.text()).put((Object)HugeKeys.ID_STRATEGY, (Object)DataType.tinyint()).put((Object)HugeKeys.PRIMARY_KEYS, (Object)DataType.list((DataType)TYPE_PK)).put((Object)HugeKeys.NULLABLE_KEYS, (Object)DataType.set((DataType)TYPE_PK)).put((Object)HugeKeys.INDEX_LABELS, (Object)DataType.set((DataType)TYPE_IL)).put((Object)HugeKeys.PROPERTIES, (Object)DataType.set((DataType)TYPE_PK)).put((Object)HugeKeys.ENABLE_LABEL_INDEX, (Object)DataType.cboolean()).put((Object)HugeKeys.USER_DATA, (Object)TYPE_UD).put((Object)HugeKeys.STATUS, (Object)DataType.tinyint()).put((Object)HugeKeys.TTL, (Object)TYPE_TTL).put((Object)HugeKeys.TTL_START_TIME, (Object)TYPE_PK).build();
            this.createTable(session, (ImmutableMap<HugeKeys, DataType>)pkeys, (ImmutableMap<HugeKeys, DataType>)ckeys, (ImmutableMap<HugeKeys, DataType>)columns);
            this.createIndex(session, CassandraTables.NAME_INDEX, HugeKeys.NAME);
        }
    }

    public static class Counters
    extends CassandraTable {
        public static final String TABLE = HugeType.COUNTER.string();

        public Counters() {
            super(TABLE);
        }

        public void init(CassandraSessionPool.Session session) {
            ImmutableMap pkeys = ImmutableMap.of((Object)HugeKeys.SCHEMA_TYPE, (Object)DataType.text());
            ImmutableMap ckeys = ImmutableMap.of();
            ImmutableMap columns = ImmutableMap.of((Object)HugeKeys.ID, (Object)DataType.counter());
            this.createTable(session, (ImmutableMap<HugeKeys, DataType>)pkeys, (ImmutableMap<HugeKeys, DataType>)ckeys, (ImmutableMap<HugeKeys, DataType>)columns);
        }

        public long getCounter(CassandraSessionPool.Session session, HugeType type) {
            Clause where = Counters.formatEQ(HugeKeys.SCHEMA_TYPE, type.name());
            Select select = QueryBuilder.select((String[])new String[]{Counters.formatKey(HugeKeys.ID)}).from(TABLE);
            select.where(where);
            Row row = session.execute((Statement)select).one();
            if (row == null) {
                return 0L;
            }
            return row.getLong(Counters.formatKey(HugeKeys.ID));
        }

        public void increaseCounter(CassandraSessionPool.Session session, HugeType type, long increment) {
            Update update = QueryBuilder.update((String)TABLE);
            update.with(QueryBuilder.incr((String)Counters.formatKey(HugeKeys.ID), (long)increment));
            update.where(Counters.formatEQ(HugeKeys.SCHEMA_TYPE, type.name()));
            session.execute((Statement)update);
        }
    }

    public static class Meta
    extends CassandraTable {
        public static final String TABLE = HugeType.META.string();

        public Meta() {
            super(TABLE);
        }

        public void init(CassandraSessionPool.Session session) {
            ImmutableMap pkeys = ImmutableMap.of((Object)HugeKeys.NAME, (Object)DataType.text());
            ImmutableMap ckeys = ImmutableMap.of();
            ImmutableMap columns = ImmutableMap.of((Object)HugeKeys.VALUE, (Object)DataType.text());
            this.createTable(session, (ImmutableMap<HugeKeys, DataType>)pkeys, (ImmutableMap<HugeKeys, DataType>)ckeys, (ImmutableMap<HugeKeys, DataType>)columns);
        }

        public void writeVersion(CassandraSessionPool.Session session, String version) {
            Insert insert = QueryBuilder.insertInto((String)TABLE);
            insert.value(Meta.formatKey(HugeKeys.NAME), (Object)Meta.formatKey(HugeKeys.VERSION));
            insert.value(Meta.formatKey(HugeKeys.VALUE), (Object)version);
            session.execute((Statement)insert);
        }

        public String readVersion(CassandraSessionPool.Session session) {
            Clause where = Meta.formatEQ(HugeKeys.NAME, Meta.formatKey(HugeKeys.VERSION));
            Select select = QueryBuilder.select((String[])new String[]{Meta.formatKey(HugeKeys.VALUE)}).from(TABLE);
            select.where(where);
            Row row = session.execute((Statement)select).one();
            if (row == null) {
                return null;
            }
            return row.getString(Meta.formatKey(HugeKeys.VALUE));
        }
    }
}

