/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.auth;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.List;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.auth.UserAPI;
import org.apache.hugegraph.api.filter.StatusFilter;
import org.apache.hugegraph.auth.HugeGroup;
import org.apache.hugegraph.auth.SchemaDefine;
import org.apache.hugegraph.backend.id.IdGenerator;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.define.Checkable;
import org.apache.hugegraph.exception.NotFoundException;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/auth/groups")
@Singleton
@Tag(name="GroupAPI")
public class GroupAPI
extends API {
    private static final Logger LOG = Log.logger(GroupAPI.class);

    @POST
    @Timed
    @StatusFilter.Status(value=201)
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String create(@Context GraphManager manager, @PathParam(value="graph") String graph, JsonGroup jsonGroup) {
        LOG.debug("Graph [{}] create group: {}", (Object)graph, (Object)jsonGroup);
        GroupAPI.checkCreatingBody(jsonGroup);
        HugeGraph g = GroupAPI.graph(manager, graph);
        HugeGroup group = jsonGroup.build();
        group.id(manager.authManager().createGroup(group));
        return manager.serializer((Graph)g).writeAuthElement((SchemaDefine.AuthElement)group);
    }

    @PUT
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String update(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String id, JsonGroup jsonGroup) {
        HugeGroup group;
        LOG.debug("Graph [{}] update group: {}", (Object)graph, (Object)jsonGroup);
        GroupAPI.checkUpdatingBody(jsonGroup);
        HugeGraph g = GroupAPI.graph(manager, graph);
        try {
            group = manager.authManager().getGroup(UserAPI.parseId(id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid group id: " + id);
        }
        group = jsonGroup.build(group);
        manager.authManager().updateGroup(group);
        return manager.serializer((Graph)g).writeAuthElement((SchemaDefine.AuthElement)group);
    }

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String list(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="limit") @DefaultValue(value="100") long limit) {
        LOG.debug("Graph [{}] list groups", (Object)graph);
        HugeGraph g = GroupAPI.graph(manager, graph);
        List groups = manager.authManager().listAllGroups(limit);
        return manager.serializer((Graph)g).writeAuthElements("groups", groups);
    }

    @GET
    @Timed
    @Path(value="{id}")
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String id) {
        LOG.debug("Graph [{}] get group: {}", (Object)graph, (Object)id);
        HugeGraph g = GroupAPI.graph(manager, graph);
        HugeGroup group = manager.authManager().getGroup(IdGenerator.of((String)id));
        return manager.serializer((Graph)g).writeAuthElement((SchemaDefine.AuthElement)group);
    }

    @DELETE
    @Timed
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public void delete(@Context GraphManager manager, @PathParam(value="graph") String graph, @PathParam(value="id") String id) {
        LOG.debug("Graph [{}] delete group: {}", (Object)graph, (Object)id);
        HugeGraph g = GroupAPI.graph(manager, graph);
        try {
            manager.authManager().deleteGroup(IdGenerator.of((String)id));
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("Invalid group id: " + id);
        }
    }

    @JsonIgnoreProperties(value={"id", "group_creator", "group_create", "group_update"})
    private static class JsonGroup
    implements Checkable {
        @JsonProperty(value="group_name")
        private String name;
        @JsonProperty(value="group_description")
        private String description;

        private JsonGroup() {
        }

        public HugeGroup build(HugeGroup group) {
            E.checkArgument((this.name == null || group.name().equals(this.name) ? 1 : 0) != 0, (String)"The name of group can't be updated", (Object[])new Object[0]);
            if (this.description != null) {
                group.description(this.description);
            }
            return group;
        }

        public HugeGroup build() {
            HugeGroup group = new HugeGroup(this.name);
            group.description(this.description);
            return group;
        }

        @Override
        public void checkCreate(boolean isBatch) {
            E.checkArgumentNotNull((Object)this.name, (String)"The name of group can't be null", (Object[])new Object[0]);
        }

        @Override
        public void checkUpdate() {
            E.checkArgumentNotNull((Object)this.description, (String)"The description of group can't be null", (Object[])new Object[0]);
        }
    }
}

