/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.api.traversers;

import com.codahale.metrics.annotation.Timed;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import java.util.Map;
import org.apache.hugegraph.HugeGraph;
import org.apache.hugegraph.api.API;
import org.apache.hugegraph.api.graph.EdgeAPI;
import org.apache.hugegraph.api.graph.VertexAPI;
import org.apache.hugegraph.api.traversers.TraverserAPI;
import org.apache.hugegraph.backend.id.Id;
import org.apache.hugegraph.core.GraphManager;
import org.apache.hugegraph.structure.HugeVertex;
import org.apache.hugegraph.traversal.algorithm.JaccardSimilarTraverser;
import org.apache.hugegraph.traversal.algorithm.steps.EdgeStep;
import org.apache.hugegraph.type.define.Directions;
import org.apache.hugegraph.util.E;
import org.apache.hugegraph.util.Log;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.slf4j.Logger;

@Path(value="graphs/{graph}/traversers/jaccardsimilarity")
@Singleton
@Tag(name="JaccardSimilarityAPI")
public class JaccardSimilarityAPI
extends TraverserAPI {
    private static final Logger LOG = Log.logger(JaccardSimilarityAPI.class);

    @GET
    @Timed
    @Produces(value={"application/json;charset=UTF-8"})
    public String get(@Context GraphManager manager, @PathParam(value="graph") String graph, @QueryParam(value="vertex") String vertex, @QueryParam(value="other") String other, @QueryParam(value="direction") String direction, @QueryParam(value="label") String edgeLabel, @QueryParam(value="max_degree") @DefaultValue(value="10000") long maxDegree) {
        double similarity;
        LOG.debug("Graph [{}] get jaccard similarity between '{}' and '{}' with direction {}, edge label {} and max degree '{}'", new Object[]{graph, vertex, other, direction, edgeLabel, maxDegree});
        API.ApiMeasurer measure = new API.ApiMeasurer();
        Id sourceId = VertexAPI.checkAndParseVertexId(vertex);
        Id targetId = VertexAPI.checkAndParseVertexId(other);
        Directions dir = Directions.convert((Direction)EdgeAPI.parseDirection(direction));
        HugeGraph g = JaccardSimilarityAPI.graph(manager, graph);
        try (JaccardSimilarTraverser traverser = new JaccardSimilarTraverser(g);){
            similarity = traverser.jaccardSimilarity(sourceId, targetId, dir, edgeLabel, maxDegree);
            measure.addIterCount(traverser.vertexIterCounter.get(), traverser.edgeIterCounter.get());
        }
        return manager.serializer((Graph)g, measure.measures()).writeMap((Map<?, ?>)ImmutableMap.of((Object)"jaccard_similarity", (Object)similarity));
    }

    @POST
    @Timed
    @Consumes(value={"application/json"})
    @Produces(value={"application/json;charset=UTF-8"})
    public String post(@Context GraphManager manager, @PathParam(value="graph") String graph, Request request) {
        Map results;
        E.checkArgumentNotNull((Object)request, (String)"The request body can't be null", (Object[])new Object[0]);
        E.checkArgumentNotNull((Object)request.vertex, (String)"The source vertex of request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.step != null ? 1 : 0) != 0, (String)"The steps of request can't be null", (Object[])new Object[0]);
        E.checkArgument((request.top >= 0 ? 1 : 0) != 0, (String)"The top must be >= 0, but got: %s", (Object[])new Object[]{request.top});
        LOG.debug("Graph [{}] get jaccard similars from source vertex '{}', with step '{}', top '{}' and capacity '{}'", new Object[]{graph, request.vertex, request.step, request.top, request.capacity});
        API.ApiMeasurer measure = new API.ApiMeasurer();
        HugeGraph g = JaccardSimilarityAPI.graph(manager, graph);
        Id sourceId = HugeVertex.getIdValue((Object)request.vertex);
        EdgeStep step = JaccardSimilarityAPI.step(g, request.step);
        try (JaccardSimilarTraverser traverser = new JaccardSimilarTraverser(g);){
            results = traverser.jaccardSimilars(sourceId, step, request.top, request.capacity);
            measure.addIterCount(traverser.vertexIterCounter.get(), traverser.edgeIterCounter.get());
        }
        return manager.serializer((Graph)g, measure.measures()).writeMap((Map<?, ?>)ImmutableMap.of((Object)"jaccard_similarity", (Object)results));
    }

    private static class Request {
        @JsonProperty(value="vertex")
        public Object vertex;
        @JsonProperty(value="step")
        public TraverserAPI.Step step;
        @JsonProperty(value="top")
        public int top = Integer.parseInt("100");
        @JsonProperty(value="capacity")
        public long capacity = Long.parseLong("10000000");

        private Request() {
        }

        public String toString() {
            return String.format("Request{vertex=%s,step=%s,top=%s,capacity=%s}", this.vertex, this.step, this.top, this.capacity);
        }
    }
}

