/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.table;

import org.apache.ignite.internal.schema.ColumnsExtractor;
import org.apache.ignite.internal.storage.index.IndexStorage;
import org.apache.ignite.internal.storage.index.SortedIndexStorage;
import org.apache.ignite.internal.table.InternalTable;
import org.apache.ignite.internal.table.distributed.HashIndexLocker;
import org.apache.ignite.internal.table.distributed.IndexLocker;
import org.apache.ignite.internal.table.distributed.SortedIndexLocker;
import org.apache.ignite.internal.table.distributed.TableSchemaAwareIndexStorage;
import org.apache.ignite.internal.tx.LockManager;
import org.jetbrains.annotations.Nullable;

abstract class IndexWrapper {
    final InternalTable tbl;
    final LockManager lockManager;
    final int indexId;
    final ColumnsExtractor indexRowResolver;

    private IndexWrapper(InternalTable tbl, LockManager lockManager, int indexId, ColumnsExtractor indexRowResolver) {
        this.tbl = tbl;
        this.lockManager = lockManager;
        this.indexId = indexId;
        this.indexRowResolver = indexRowResolver;
    }

    @Nullable
    abstract TableSchemaAwareIndexStorage getStorage(int var1);

    abstract IndexLocker getLocker(int var1);

    static class HashIndexWrapper
    extends IndexWrapper {
        private final boolean unique;

        HashIndexWrapper(InternalTable tbl, LockManager lockManager, int indexId, ColumnsExtractor indexRowResolver, boolean unique) {
            super(tbl, lockManager, indexId, indexRowResolver);
            this.unique = unique;
        }

        @Override
        @Nullable
        TableSchemaAwareIndexStorage getStorage(int partitionId) {
            IndexStorage index = this.tbl.storage().getIndex(partitionId, this.indexId);
            if (index == null) {
                return null;
            }
            return new TableSchemaAwareIndexStorage(this.indexId, index, this.indexRowResolver);
        }

        @Override
        IndexLocker getLocker(int partitionId) {
            return new HashIndexLocker(this.indexId, this.unique, this.lockManager, this.indexRowResolver);
        }
    }

    static class SortedIndexWrapper
    extends IndexWrapper {
        private final boolean unique;

        SortedIndexWrapper(InternalTable tbl, LockManager lockManager, int indexId, ColumnsExtractor indexRowResolver, boolean unique) {
            super(tbl, lockManager, indexId, indexRowResolver);
            this.unique = unique;
        }

        @Override
        @Nullable
        TableSchemaAwareIndexStorage getStorage(int partitionId) {
            IndexStorage index = this.tbl.storage().getIndex(partitionId, this.indexId);
            if (index == null) {
                return null;
            }
            return new TableSchemaAwareIndexStorage(this.indexId, index, this.indexRowResolver);
        }

        @Override
        IndexLocker getLocker(int partitionId) {
            IndexStorage index = this.tbl.storage().getIndex(partitionId, this.indexId);
            assert (index != null) : String.valueOf(this.tbl.name()) + " part " + partitionId;
            return new SortedIndexLocker(this.indexId, partitionId, this.lockManager, (SortedIndexStorage)index, this.indexRowResolver, this.unique);
        }
    }
}

