/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.lookup;

import java.util.Map;
import java.util.Set;
import org.apache.calcite.schema.lookup.LikePattern;
import org.apache.calcite.schema.lookup.Lookup;
import org.apache.calcite.schema.lookup.Named;
import org.apache.calcite.util.LazyReference;
import org.apache.calcite.util.NameMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class IgnoreCaseLookup<T>
implements Lookup<T> {
    private LazyReference<NameMap<String>> nameMap = new LazyReference();

    @Override
    public abstract @Nullable T get(String var1);

    @Override
    public @Nullable Named<T> getIgnoreCase(String name) {
        int retryCounter = 0;
        while (true) {
            Map.Entry entry;
            if ((entry = this.nameMap.getOrCompute(this::loadNames).range(name, false).firstEntry()) != null) {
                T result = this.get((String)entry.getValue());
                return result == null ? null : new Named<T>(entry.getKey(), result);
            }
            if (++retryCounter > 1) {
                return null;
            }
            this.nameMap.reset();
        }
    }

    @Override
    public abstract Set<String> getNames(LikePattern var1);

    private NameMap<String> loadNames() {
        NameMap<String> result = new NameMap<String>();
        for (String name : this.getNames(LikePattern.any())) {
            result.put(name, name);
        }
        return result;
    }
}

