/*
 * Decompiled with CFR 0.152.
 */
package me.tongfei.progressbar;

import java.io.PrintStream;
import me.tongfei.progressbar.ProgressBarConsumer;
import me.tongfei.progressbar.StringDisplayUtils;
import me.tongfei.progressbar.TerminalUtils;

public class ConsoleProgressBarConsumer
implements ProgressBarConsumer {
    private static int consoleRightMargin = 1;
    int maxRenderedLength = -1;
    final PrintStream out;

    public ConsoleProgressBarConsumer(PrintStream out) {
        this.out = out;
    }

    public ConsoleProgressBarConsumer(PrintStream out, int maxRenderedLength) {
        this.maxRenderedLength = maxRenderedLength;
        this.out = out;
    }

    @Override
    public int getMaxRenderedLength() {
        if (this.maxRenderedLength <= 0) {
            return TerminalUtils.getTerminalWidth() - consoleRightMargin;
        }
        return this.maxRenderedLength;
    }

    @Override
    public void accept(String str) {
        this.out.print('\r' + StringDisplayUtils.trimDisplayLength(str, this.getMaxRenderedLength()));
    }

    @Override
    public void close() {
        this.out.println();
        this.out.flush();
    }
}

