/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.deployunit.metastore.status;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.deployment.version.Version;
import org.apache.ignite.internal.deployunit.DeploymentStatus;
import org.apache.ignite.internal.deployunit.UnitStatus;
import org.apache.ignite.internal.deployunit.metastore.status.SerializeUtils;
import org.apache.ignite.internal.tostring.S;
import org.jetbrains.annotations.Nullable;

public class UnitClusterStatus
extends UnitStatus {
    private final Set<String> initialNodesToDeploy;

    public UnitClusterStatus(String id, Version version, DeploymentStatus status, UUID opId, Set<String> initialNodesToDeploy) {
        super(id, version, status, opId);
        this.initialNodesToDeploy = Collections.unmodifiableSet(initialNodesToDeploy);
    }

    public Set<String> initialNodesToDeploy() {
        return this.initialNodesToDeploy;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UnitClusterStatus status = (UnitClusterStatus)o;
        return this.initialNodesToDeploy != null ? this.initialNodesToDeploy.equals(status.initialNodesToDeploy) : status.initialNodesToDeploy == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.initialNodesToDeploy != null ? this.initialNodesToDeploy.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return S.toString(UnitClusterStatus.class, (Object)this, (String)super.toString());
    }

    public static byte[] serialize(UnitClusterStatus status) {
        return SerializeUtils.serialize(new Object[]{status.id(), status.version(), status.status(), status.opId(), status.initialNodesToDeploy});
    }

    public static UnitClusterStatus deserialize(byte @Nullable [] value) {
        if (value == null || value.length == 0) {
            return new UnitClusterStatus(null, null, null, null, Set.of());
        }
        String[] values = SerializeUtils.deserialize(value);
        String id = SerializeUtils.checkElement(values, 0) ? SerializeUtils.decode(values[0]) : null;
        Version version = SerializeUtils.deserializeVersion(values, 1);
        DeploymentStatus status = SerializeUtils.deserializeStatus(values, 2);
        UUID opId = SerializeUtils.deserializeUuid(values, 3);
        Set<String> nodes = SerializeUtils.checkElement(values, 4) ? SerializeUtils.decodeAsSet(values[4]) : Set.of();
        return new UnitClusterStatus(id, version, status, opId, nodes);
    }
}

