/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.restart;

import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite.compute.BroadcastExecution;
import org.apache.ignite.compute.BroadcastJobTarget;
import org.apache.ignite.compute.IgniteCompute;
import org.apache.ignite.compute.JobDescriptor;
import org.apache.ignite.compute.JobExecution;
import org.apache.ignite.compute.JobTarget;
import org.apache.ignite.compute.TaskDescriptor;
import org.apache.ignite.compute.task.TaskExecution;
import org.apache.ignite.internal.restart.IgniteAttachmentLock;
import org.apache.ignite.internal.wrapper.Wrapper;
import org.apache.ignite.internal.wrapper.Wrappers;
import org.apache.ignite.lang.CancellationToken;
import org.jetbrains.annotations.Nullable;

class RestartProofIgniteCompute
implements IgniteCompute,
Wrapper {
    private final IgniteAttachmentLock attachmentLock;

    RestartProofIgniteCompute(IgniteAttachmentLock attachmentLock) {
        this.attachmentLock = attachmentLock;
    }

    public <T, R> CompletableFuture<JobExecution<R>> submitAsync(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.compute().submitAsync(target, descriptor, arg, cancellationToken));
    }

    public <T, R> CompletableFuture<BroadcastExecution<R>> submitAsync(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.compute().submitAsync(target, descriptor, arg, cancellationToken));
    }

    public <T, R> R execute(JobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return (R)this.attachmentLock.attached(ignite -> ignite.compute().execute(target, descriptor, arg, cancellationToken));
    }

    public <T, R> Collection<R> execute(BroadcastJobTarget target, JobDescriptor<T, R> descriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.attachmentLock.attached(ignite -> ignite.compute().execute(target, descriptor, arg, cancellationToken));
    }

    public <T, R> TaskExecution<R> submitMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.attachmentLock.attached(ignite -> ignite.compute().submitMapReduce(taskDescriptor, arg, cancellationToken));
    }

    public <T, R> CompletableFuture<R> executeMapReduceAsync(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return this.attachmentLock.attachedAsync(ignite -> ignite.compute().executeMapReduceAsync(taskDescriptor, arg, cancellationToken));
    }

    public <T, R> R executeMapReduce(TaskDescriptor<T, R> taskDescriptor, @Nullable T arg, @Nullable CancellationToken cancellationToken) {
        return (R)this.attachmentLock.attached(ignite -> ignite.compute().executeMapReduce(taskDescriptor, arg, cancellationToken));
    }

    public <T> T unwrap(Class<T> classToUnwrap) {
        return (T)this.attachmentLock.attached(ignite -> Wrappers.unwrap((Object)ignite.compute(), (Class)classToUnwrap));
    }
}

