/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;
import org.apache.ignite.internal.hlc.HybridTimestamp;
import org.apache.ignite.internal.network.serialization.MessageCollectionItemType;
import org.apache.ignite.internal.network.serialization.MessageDeserializer;
import org.apache.ignite.internal.network.serialization.MessageMappingException;
import org.apache.ignite.internal.network.serialization.MessageReader;
import org.apache.ignite.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteMultiRowPkReplicaRequest;
import org.apache.ignite.internal.partition.replicator.network.replication.ReadWriteMultiRowPkReplicaRequestBuilder;
import org.apache.ignite.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite.internal.replicator.message.ReplicationGroupIdMessage;

class ReadWriteMultiRowPkReplicaRequestDeserializer
implements MessageDeserializer<ReadWriteMultiRowPkReplicaRequest> {
    private final ReadWriteMultiRowPkReplicaRequestBuilder msg;

    ReadWriteMultiRowPkReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readWriteMultiRowPkReplicaRequest();
    }

    public Class<ReadWriteMultiRowPkReplicaRequest> klass() {
        return ReadWriteMultiRowPkReplicaRequest.class;
    }

    public ReadWriteMultiRowPkReplicaRequest getMessage() {
        return this.msg.build();
    }

    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Comparable<UUID> tmp = (ReplicationGroupIdMessage)reader.readMessage("commitPartitionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.commitPartitionId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 1: {
                Comparable<UUID> tmp = reader.readUuid("coordinatorId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.coordinatorId((UUID)tmp);
                reader.incrementState();
            }
            case 2: {
                Comparable<UUID> tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.enlistmentConsistencyToken((Long)tmp);
                reader.incrementState();
            }
            case 3: {
                boolean tmp = reader.readBoolean("full");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.full(tmp);
                reader.incrementState();
            }
            case 4: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 5: {
                Object tmp = reader.readList("primaryKeys", MessageCollectionItemType.BYTE_BUFFER);
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.primaryKeys((List<ByteBuffer>)tmp);
                reader.incrementState();
            }
            case 6: {
                int shiftedId = reader.readInt("requestType");
                if (!reader.isLastRead()) {
                    return false;
                }
                RequestType tmp = shiftedId == 0 ? null : RequestType.fromId(shiftedId - 1);
                this.msg.requestType(tmp);
                reader.incrementState();
            }
            case 7: {
                int tmp = reader.readInt("schemaVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.schemaVersion(tmp);
                reader.incrementState();
            }
            case 8: {
                int tmp = reader.readBoolean("skipDelayedAck") ? 1 : 0;
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.skipDelayedAck(tmp != 0);
                reader.incrementState();
            }
            case 9: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 10: {
                Object tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp((HybridTimestamp)tmp);
                reader.incrementState();
            }
            case 11: {
                Object tmp = reader.readUuid("transactionId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.transactionId((UUID)tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadWriteMultiRowPkReplicaRequest.class);
    }
}

