/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.consistency;

import java.util.Collection;
import java.util.function.Consumer;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.ComputeCommand;
import org.apache.ignite.internal.management.api.NoArg;
import org.apache.ignite.internal.management.consistency.ConsistencyStatusTask;
import org.apache.ignite.internal.management.consistency.ConsistencyTaskResult;
import org.apache.ignite.lang.IgniteExperimental;

@IgniteExperimental
public class ConsistencyStatusCommand
implements ComputeCommand<NoArg, ConsistencyTaskResult> {
    @Override
    public String description() {
        return "Cache consistency check/repair operations status";
    }

    @Override
    public Class<NoArg> argClass() {
        return NoArg.class;
    }

    @Override
    public Class<ConsistencyStatusTask> taskClass() {
        return ConsistencyStatusTask.class;
    }

    @Override
    public Collection<GridClientNode> nodes(Collection<GridClientNode> nodes, NoArg arg) {
        return CommandUtils.servers(nodes);
    }

    @Override
    public void printResult(NoArg arg, ConsistencyTaskResult res, Consumer<String> printer) {
        if (res.cancelled()) {
            printer.accept("Operation execution cancelled.\n\n");
        }
        if (res.failed()) {
            printer.accept("Operation execution failed.\n\n");
        }
        if (res.cancelled() || res.failed()) {
            printer.accept("[EXECUTION FAILED OR CANCELLED, RESULTS MAY BE INCOMPLETE OR INCONSISTENT]\n\n");
        }
        printer.accept(res.message());
    }
}

