/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.checkpoint;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.internal.processors.cache.persistence.GridCacheDatabaseSharedManager;
import org.apache.ignite.internal.util.ReentrantReadWriteLockWithTracking;

public class CheckpointReadWriteLock {
    private static final boolean ASSERTION_ENABLED = GridCacheDatabaseSharedManager.class.desiredAssertionStatus();
    public static final ThreadLocal<Integer> CHECKPOINT_LOCK_HOLD_COUNT = ThreadLocal.withInitial(() -> 0);
    static final String CHECKPOINT_RUNNER_THREAD_PREFIX = "checkpoint-runner";
    private final ReentrantReadWriteLockWithTracking checkpointLock;

    CheckpointReadWriteLock(Function<Class<?>, IgniteLogger> logger) {
        this.checkpointLock = IgniteSystemProperties.getBoolean("IGNITE_PDS_LOG_CP_READ_LOCK_HOLDERS") ? new ReentrantReadWriteLockWithTracking(logger.apply(this.getClass()), 5000L) : new ReentrantReadWriteLockWithTracking();
    }

    public void readLock() {
        if (this.checkpointLock.writeLock().isHeldByCurrentThread()) {
            return;
        }
        this.checkpointLock.readLock().lock();
        if (ASSERTION_ENABLED) {
            CHECKPOINT_LOCK_HOLD_COUNT.set(CHECKPOINT_LOCK_HOLD_COUNT.get() + 1);
        }
    }

    public boolean tryReadLock(long timeout, TimeUnit unit) throws InterruptedException {
        if (this.checkpointLock.writeLock().isHeldByCurrentThread()) {
            return true;
        }
        boolean res = this.checkpointLock.readLock().tryLock(timeout, unit);
        if (ASSERTION_ENABLED) {
            CHECKPOINT_LOCK_HOLD_COUNT.set(CHECKPOINT_LOCK_HOLD_COUNT.get() + 1);
        }
        return res;
    }

    public boolean checkpointLockIsHeldByThread() {
        return !ASSERTION_ENABLED || this.checkpointLock.isWriteLockedByCurrentThread() || CHECKPOINT_LOCK_HOLD_COUNT.get() > 0 || Thread.currentThread().getName().startsWith(CHECKPOINT_RUNNER_THREAD_PREFIX);
    }

    public void readUnlock() {
        if (this.checkpointLock.writeLock().isHeldByCurrentThread()) {
            return;
        }
        this.checkpointLock.readLock().unlock();
        if (ASSERTION_ENABLED) {
            CHECKPOINT_LOCK_HOLD_COUNT.set(CHECKPOINT_LOCK_HOLD_COUNT.get() - 1);
        }
    }

    public void writeLock() {
        this.checkpointLock.writeLock().lock();
    }

    public boolean isWriteLockHeldByCurrentThread() {
        return this.checkpointLock.writeLock().isHeldByCurrentThread();
    }

    public void writeUnlock() {
        this.checkpointLock.writeLock().unlock();
    }

    public int getReadHoldCount() {
        return this.checkpointLock.getReadHoldCount();
    }
}

