/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.wal.filehandle;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.LockSupport;
import java.util.function.Supplier;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.configuration.WALMode;
import org.apache.ignite.failure.FailureContext;
import org.apache.ignite.failure.FailureType;
import org.apache.ignite.internal.IgniteInterruptedCheckedException;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.persistence.DataStorageMetricsImpl;
import org.apache.ignite.internal.processors.cache.persistence.StorageException;
import org.apache.ignite.internal.processors.cache.persistence.wal.SegmentedRingByteBuffer;
import org.apache.ignite.internal.processors.cache.persistence.wal.WALPointer;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FileHandleManager;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FileWriteHandle;
import org.apache.ignite.internal.processors.cache.persistence.wal.filehandle.FileWriteHandleImpl;
import org.apache.ignite.internal.processors.cache.persistence.wal.io.SegmentIO;
import org.apache.ignite.internal.processors.cache.persistence.wal.serializer.RecordSerializer;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.util.worker.GridWorker;
import org.apache.ignite.thread.IgniteThread;

public class FileHandleManagerImpl
implements FileHandleManager {
    public static final long DFLT_WAL_SEGMENT_SYNC_TIMEOUT = 500L;
    private final WALWriter walWriter;
    private final WalSegmentSyncer walSegmentSyncWorker;
    protected final GridCacheSharedContext cctx;
    private final IgniteLogger log;
    private final WALMode mode;
    private final DataStorageMetricsImpl metrics;
    private final boolean mmap;
    private final RecordSerializer serializer;
    private final Supplier<FileWriteHandle> currentHandleSupplier;
    private final int walBufferSize;
    private final long maxWalSegmentSize;
    private final long fsyncDelay;

    public FileHandleManagerImpl(GridCacheSharedContext cctx, DataStorageMetricsImpl metrics, boolean mmap, RecordSerializer serializer, Supplier<FileWriteHandle> currentHandleSupplier, WALMode mode, int walBufferSize, long maxWalSegmentSize, long fsyncDelay) {
        this.cctx = cctx;
        this.log = cctx.logger(FileHandleManagerImpl.class);
        this.mode = mode;
        this.metrics = metrics;
        this.mmap = mmap;
        this.serializer = serializer;
        this.currentHandleSupplier = currentHandleSupplier;
        this.walBufferSize = walBufferSize;
        this.maxWalSegmentSize = maxWalSegmentSize;
        this.fsyncDelay = fsyncDelay;
        this.walWriter = new WALWriter(this.log);
        if (mode != WALMode.NONE && mode != WALMode.FSYNC) {
            this.walSegmentSyncWorker = new WalSegmentSyncer(cctx.igniteInstanceName(), cctx.kernalContext().log(WalSegmentSyncer.class));
            if (this.log.isInfoEnabled()) {
                this.log.info("Initialized write-ahead log manager [mode=" + (Object)((Object)mode) + ']');
            }
        } else {
            U.quietAndWarn(this.log, "Initialized write-ahead log manager in NONE mode, persisted data may be lost in a case of unexpected node failure. Make sure to deactivate the cluster before shutdown.");
            this.walSegmentSyncWorker = null;
        }
    }

    @Override
    public FileWriteHandle initHandle(SegmentIO fileIO, long position, RecordSerializer serializer) throws IOException {
        SegmentedRingByteBuffer rbuf;
        if (this.mmap) {
            MappedByteBuffer buf = fileIO.map((int)this.maxWalSegmentSize);
            rbuf = new SegmentedRingByteBuffer(buf, this.metrics);
        } else {
            rbuf = new SegmentedRingByteBuffer(this.walBufferSize, this.maxWalSegmentSize, SegmentedRingByteBuffer.BufferMode.DIRECT, this.metrics);
        }
        rbuf.init(position);
        return new FileWriteHandleImpl(this.cctx, fileIO, rbuf, serializer, this.metrics, this.walWriter, position, this.mode, this.mmap, true, this.fsyncDelay, this.maxWalSegmentSize);
    }

    @Override
    public FileWriteHandle nextHandle(SegmentIO fileIO, RecordSerializer serializer) throws IOException {
        SegmentedRingByteBuffer rbuf;
        if (this.mmap) {
            MappedByteBuffer buf = fileIO.map((int)this.maxWalSegmentSize);
            rbuf = new SegmentedRingByteBuffer(buf, this.metrics);
        } else {
            rbuf = this.currentHandle().buf.reset();
        }
        try {
            return new FileWriteHandleImpl(this.cctx, fileIO, rbuf, serializer, this.metrics, this.walWriter, 0L, this.mode, this.mmap, false, this.fsyncDelay, this.maxWalSegmentSize);
        }
        catch (ClosedByInterruptException e) {
            if (rbuf != null) {
                rbuf.free();
            }
            return null;
        }
    }

    private FileWriteHandleImpl currentHandle() {
        return (FileWriteHandleImpl)this.currentHandleSupplier.get();
    }

    @Override
    public void onDeactivate() throws IgniteCheckedException {
        FileWriteHandleImpl currHnd = this.currentHandle();
        try {
            if (this.mode == WALMode.BACKGROUND && currHnd != null) {
                currHnd.flush(null);
            }
            if (currHnd != null) {
                currHnd.close(false);
            }
        }
        finally {
            if (this.walSegmentSyncWorker != null) {
                this.walSegmentSyncWorker.shutdown();
            }
            this.walWriter.shutdown();
        }
    }

    @Override
    public void resumeLogging() {
        if (!this.mmap) {
            this.walWriter.restart();
        }
        if (this.cctx.kernalContext().clientNode()) {
            return;
        }
        if (this.walSegmentSyncWorker != null) {
            this.walSegmentSyncWorker.restart();
        }
    }

    @Override
    public WALPointer flush(WALPointer ptr, boolean explicitFsync) throws IgniteCheckedException, StorageException {
        WALPointer filePtr;
        if (this.serializer == null || this.mode == WALMode.NONE) {
            return null;
        }
        FileWriteHandleImpl cur = this.currentHandle();
        if (cur == null) {
            return null;
        }
        if (ptr == null) {
            long pos = cur.buf.tail();
            filePtr = new WALPointer(cur.getSegmentId(), (int)pos, 0);
        } else {
            filePtr = ptr;
        }
        if (this.mode == WALMode.LOG_ONLY) {
            cur.flushOrWait(filePtr);
        }
        if (!explicitFsync && this.mode != WALMode.FSYNC) {
            return filePtr;
        }
        if (!cur.needFsync(filePtr)) {
            return filePtr;
        }
        cur.fsync(filePtr);
        return filePtr;
    }

    private void checkNode() throws StorageException {
        if (this.cctx.kernalContext().invalid()) {
            throw new StorageException("Failed to perform WAL operation (environment was invalidated by a previous error)");
        }
    }

    private class WalSegmentSyncer
    extends GridWorker {
        private final long syncTimeout;

        private WalSegmentSyncer(String igniteInstanceName, IgniteLogger log) {
            super(igniteInstanceName, "wal-segment-syncer", log);
            this.syncTimeout = Math.max(IgniteSystemProperties.getLong("IGNITE_WAL_SEGMENT_SYNC_TIMEOUT", 500L), 100L);
        }

        @Override
        protected void body() throws InterruptedException, IgniteInterruptedCheckedException {
            while (!this.isCancelled()) {
                IgniteUtils.sleep(this.syncTimeout);
                try {
                    FileHandleManagerImpl.this.flush(null, true);
                }
                catch (IgniteCheckedException e) {
                    U.error(this.log, "Exception when flushing WAL.", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shutdown() {
            WalSegmentSyncer walSegmentSyncer = this;
            synchronized (walSegmentSyncer) {
                U.cancel(this);
            }
            U.join(this, this.log);
        }

        public void restart() {
            assert (this.runner() == null) : "WalSegmentSyncer is running.";
            this.isCancelled = false;
            new IgniteThread(FileHandleManagerImpl.this.walSegmentSyncWorker).start();
        }
    }

    public class WALWriter
    extends GridWorker {
        private static final long UNCONDITIONAL_FLUSH = -1L;
        private static final long FILE_CLOSE = -2L;
        private static final long FILE_FORCE = -3L;
        private volatile Throwable err;
        final Map<Thread, Long> waiters;

        WALWriter(IgniteLogger log) {
            super(FileHandleManagerImpl.this.cctx.igniteInstanceName(), "wal-write-worker%" + FileHandleManagerImpl.this.cctx.igniteInstanceName(), log, FileHandleManagerImpl.this.cctx.kernalContext().workersRegistry());
            this.waiters = new ConcurrentHashMap<Thread, Long>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void body() {
            Throwable err = null;
            try {
                while (!this.isCancelled()) {
                    this.onIdle();
                    while (this.waiters.isEmpty()) {
                        if (!this.isCancelled()) {
                            this.blockingSectionBegin();
                            try {
                                LockSupport.park();
                                continue;
                            }
                            finally {
                                this.blockingSectionEnd();
                                continue;
                            }
                        }
                        this.unparkWaiters(Long.MAX_VALUE);
                        return;
                    }
                    Long pos = null;
                    for (Long val : this.waiters.values()) {
                        if (val <= Long.MIN_VALUE) continue;
                        pos = val;
                    }
                    this.updateHeartbeat();
                    if (pos == null) continue;
                    if (pos < -1L) {
                        try {
                            assert (pos == -2L || pos == -3L) : pos;
                            if (pos == -2L) {
                                ((FileHandleManagerImpl)FileHandleManagerImpl.this).currentHandle().fileIO.close();
                            } else if (pos == -3L) {
                                ((FileHandleManagerImpl)FileHandleManagerImpl.this).currentHandle().fileIO.force();
                            }
                        }
                        catch (IOException e) {
                            this.log.error("Exception in WAL writer thread: ", e);
                            err = e;
                            this.unparkWaiters(Long.MAX_VALUE);
                            this.err = err;
                            this.unparkWaiters(Long.MAX_VALUE);
                            if (err == null && !this.isCancelled) {
                                err = new IllegalStateException("Worker " + this.name() + " is terminated unexpectedly");
                            }
                            if (err instanceof OutOfMemoryError) {
                                FileHandleManagerImpl.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                            } else if (err != null) {
                                FileHandleManagerImpl.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                            }
                            return;
                        }
                        this.unparkWaiters(pos);
                    }
                    this.updateHeartbeat();
                    List<SegmentedRingByteBuffer.ReadSegment> segs = ((FileHandleManagerImpl)FileHandleManagerImpl.this).currentHandle().buf.poll(pos);
                    if (segs == null) {
                        this.unparkWaiters(pos);
                        continue;
                    }
                    for (int i = 0; i < segs.size(); ++i) {
                        long p;
                        boolean unparkAll;
                        SegmentedRingByteBuffer.ReadSegment seg = segs.get(i);
                        this.updateHeartbeat();
                        try {
                            this.writeBuffer(seg.position(), seg.buffer());
                            seg.release();
                            unparkAll = pos == -1L || pos == -2L || err != null;
                        }
                        catch (Throwable e) {
                            try {
                                this.log.error("Exception in WAL writer thread:", e);
                                err = e;
                                seg.release();
                                unparkAll = pos == -1L || pos == -2L || err != null;
                            }
                            catch (Throwable throwable) {
                                seg.release();
                                boolean unparkAll2 = pos == -1L || pos == -2L || err != null;
                                long p2 = unparkAll2 ? Long.MAX_VALUE : ((FileHandleManagerImpl)FileHandleManagerImpl.this).currentHandle().written;
                                this.unparkWaiters(p2);
                                throw throwable;
                            }
                            p = unparkAll ? Long.MAX_VALUE : ((FileHandleManagerImpl)FileHandleManagerImpl.this).currentHandle().written;
                            this.unparkWaiters(p);
                            continue;
                        }
                        p = unparkAll ? Long.MAX_VALUE : ((FileHandleManagerImpl)FileHandleManagerImpl.this).currentHandle().written;
                        this.unparkWaiters(p);
                        continue;
                    }
                }
            }
            catch (Throwable t) {
                err = t;
            }
            finally {
                this.err = err;
                this.unparkWaiters(Long.MAX_VALUE);
                if (err == null && !this.isCancelled) {
                    err = new IllegalStateException("Worker " + this.name() + " is terminated unexpectedly");
                }
                if (err instanceof OutOfMemoryError) {
                    FileHandleManagerImpl.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
                } else if (err != null) {
                    FileHandleManagerImpl.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.SYSTEM_WORKER_TERMINATION, err));
                }
            }
        }

        private void shutdown() throws IgniteInterruptedCheckedException {
            U.cancel(this);
            Thread runner = this.runner();
            if (runner != null) {
                LockSupport.unpark(runner);
                U.join(runner);
            }
            assert (FileHandleManagerImpl.this.walWriter.runner() == null) : "WALWriter should be stopped.";
        }

        private void unparkWaiters(long pos) {
            assert (pos > Long.MIN_VALUE) : pos;
            for (Map.Entry<Thread, Long> e : this.waiters.entrySet()) {
                Long val = e.getValue();
                if (val > pos) continue;
                if (val != Long.MIN_VALUE) {
                    this.waiters.put(e.getKey(), Long.MIN_VALUE);
                }
                LockSupport.unpark(e.getKey());
            }
        }

        void force() throws IgniteCheckedException {
            this.flushBuffer(-3L);
        }

        void close() throws IgniteCheckedException {
            this.flushBuffer(-2L);
        }

        void flushAll() throws IgniteCheckedException {
            this.flushBuffer(-1L);
        }

        void flushBuffer(long expPos) throws IgniteCheckedException {
            if (FileHandleManagerImpl.this.mmap) {
                return;
            }
            Throwable err = ((FileHandleManagerImpl)FileHandleManagerImpl.this).walWriter.err;
            if (err != null) {
                FileHandleManagerImpl.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, err));
            }
            if (expPos == -1L) {
                expPos = ((FileHandleManagerImpl)FileHandleManagerImpl.this).currentHandle().buf.tail();
            }
            Thread t = Thread.currentThread();
            this.waiters.put(t, expPos);
            LockSupport.unpark(FileHandleManagerImpl.this.walWriter.runner());
            while (true) {
                Long val = this.waiters.get(t);
                assert (val != null) : "Only this thread can remove thread from waiters";
                if (val == Long.MIN_VALUE) {
                    this.waiters.remove(t);
                    Throwable walWriterError = ((FileHandleManagerImpl)FileHandleManagerImpl.this).walWriter.err;
                    if (walWriterError != null) {
                        throw new IgniteCheckedException("Flush buffer failed.", walWriterError);
                    }
                    return;
                }
                LockSupport.park();
            }
        }

        private void writeBuffer(long pos, ByteBuffer buf) throws StorageException, IgniteCheckedException {
            FileWriteHandleImpl hdl = FileHandleManagerImpl.this.currentHandle();
            assert (hdl.fileIO != null) : "Writing to a closed segment.";
            FileHandleManagerImpl.this.checkNode();
            long lastLogged = U.currentTimeMillis();
            long logBackoff = 2000L;
            while (hdl.written != pos) {
                assert (hdl.written < pos) : "written = " + hdl.written + ", pos = " + pos;
                long now = U.currentTimeMillis();
                if (now - lastLogged >= logBackoff) {
                    if (logBackoff < 3600000L) {
                        logBackoff *= 2L;
                    }
                    U.warn(this.log, "Still waiting for a concurrent write to complete [written=" + hdl.written + ", pos=" + pos + ", lastFsyncPos=" + hdl.lastFsyncPos + ", stop=" + hdl.stop.get() + ", actualPos=" + hdl.safePosition() + ']');
                    lastLogged = now;
                }
                FileHandleManagerImpl.this.checkNode();
            }
            int size = buf.remaining();
            assert (size > 0) : size;
            try {
                assert (hdl.written == hdl.fileIO.position());
                hdl.written += (long)hdl.fileIO.writeFully(buf);
                FileHandleManagerImpl.this.metrics.onWalBytesWritten(size);
                assert (hdl.written == hdl.fileIO.position());
            }
            catch (IOException e) {
                this.err = e;
                StorageException se = new StorageException("Failed to write buffer.", e);
                FileHandleManagerImpl.this.cctx.kernalContext().failure().process(new FailureContext(FailureType.CRITICAL_ERROR, se));
                throw se;
            }
        }

        public void restart() {
            assert (this.runner() == null) : "WALWriter is still running.";
            this.isCancelled = false;
            new IgniteThread(this).start();
        }
    }
}

