/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.bulkload.BulkLoadAckClientParameters;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcProtocolContext;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcResult;
import org.apache.ignite.internal.util.typedef.internal.S;

public class JdbcBulkLoadAckResult
extends JdbcResult {
    private long cursorId;
    private BulkLoadAckClientParameters params;

    public JdbcBulkLoadAckResult() {
        super((byte)16);
        this.cursorId = 0L;
        this.params = null;
    }

    public JdbcBulkLoadAckResult(long cursorId, BulkLoadAckClientParameters params) {
        super((byte)16);
        this.cursorId = cursorId;
        this.params = params;
    }

    public long cursorId() {
        return this.cursorId;
    }

    public BulkLoadAckClientParameters params() {
        return this.params;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.writeBinary(writer, protoCtx);
        writer.writeLong(this.cursorId);
        writer.writeString(this.params.localFileName());
        writer.writeInt(this.params.packetSize());
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader, JdbcProtocolContext protoCtx) throws BinaryObjectException {
        super.readBinary(reader, protoCtx);
        this.cursorId = reader.readLong();
        String locFileName = reader.readString();
        int batchSize = reader.readInt();
        if (!BulkLoadAckClientParameters.isValidPacketSize(batchSize)) {
            throw new BinaryObjectException(BulkLoadAckClientParameters.packetSizeErrorMesssage(batchSize));
        }
        this.params = new BulkLoadAckClientParameters(locFileName, batchSize);
    }

    @Override
    public String toString() {
        return S.toString(JdbcBulkLoadAckResult.class, this);
    }
}

