/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.platform.entityframework;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;

public class PlatformDotNetEntityFrameworkCacheEntry
implements Binarylizable {
    private String[] entitySets;
    private byte[] data;

    public PlatformDotNetEntityFrameworkCacheEntry() {
    }

    PlatformDotNetEntityFrameworkCacheEntry(String[] entitySets, byte[] data) {
        this.entitySets = entitySets;
        this.data = data;
    }

    public String[] entitySets() {
        return this.entitySets;
    }

    public byte[] data() {
        return this.data;
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter raw = writer.rawWriter();
        if (this.entitySets != null) {
            raw.writeInt(this.entitySets.length);
            for (String entitySet : this.entitySets) {
                raw.writeString(entitySet);
            }
        } else {
            raw.writeInt(-1);
        }
        raw.writeByteArray(this.data);
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader raw = reader.rawReader();
        int cnt = raw.readInt();
        if (cnt >= 0) {
            this.entitySets = new String[cnt];
            for (int i = 0; i < cnt; ++i) {
                this.entitySets[i] = raw.readString();
            }
        } else {
            this.entitySets = null;
        }
        this.data = raw.readByteArray();
    }
}

