/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import org.apache.ignite.internal.util.typedef.internal.SB;

public final class GridStringBuilderFactory {
    private static ThreadLocal<CachedBuilder> builders = new ThreadLocal<CachedBuilder>(){

        @Override
        protected CachedBuilder initialValue() {
            return new CachedBuilder();
        }
    };

    public static SB acquire() {
        return builders.get().acquire();
    }

    public static void release(SB builder) {
        builders.get().release(builder);
    }

    private GridStringBuilderFactory() {
    }

    private static class CachedBuilder {
        private SB builder = new SB();
        private boolean used;

        private CachedBuilder() {
        }

        public SB acquire() {
            if (this.used) {
                return new SB();
            }
            this.used = true;
            return this.builder;
        }

        public void release(SB builder) {
            if (this.builder == builder) {
                builder.setLength(0);
                this.used = false;
            }
        }
    }
}

