/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlMetadata;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.cache.VisorCacheMetadataTaskArg;
import org.apache.ignite.internal.visor.cache.VisorCacheSqlMetadata;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

@GridInternal
public class VisorCacheMetadataTask
extends VisorOneNodeTask<VisorCacheMetadataTaskArg, VisorCacheSqlMetadata> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheMetadataJob job(VisorCacheMetadataTaskArg arg) {
        return new VisorCacheMetadataJob(arg, this.debug);
    }

    private static class VisorCacheMetadataJob
    extends VisorJob<VisorCacheMetadataTaskArg, VisorCacheSqlMetadata> {
        private static final long serialVersionUID = 0L;

        private VisorCacheMetadataJob(VisorCacheMetadataTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorCacheSqlMetadata run(VisorCacheMetadataTaskArg arg) {
            try {
                IgniteInternalCache cache = this.ignite.cachex(arg.getCacheName());
                if (cache != null) {
                    GridCacheSqlMetadata meta = F.first(cache.context().queries().sqlMetadata());
                    if (meta != null) {
                        return new VisorCacheSqlMetadata(meta);
                    }
                    return null;
                }
                throw new IgniteException("Cache not found: " + VisorTaskUtils.escapeName(arg.getCacheName()));
            }
            catch (IgniteCheckedException e) {
                throw U.convertException(e);
            }
        }

        public String toString() {
            return S.toString(VisorCacheMetadataJob.class, this);
        }
    }
}

