/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.cache.CacheKeyConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;

public class VisorCacheKeyConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private String typeName;
    private String affKeyFieldName;

    public static List<VisorCacheKeyConfiguration> list(CacheKeyConfiguration[] cfgs) {
        ArrayList<VisorCacheKeyConfiguration> res = new ArrayList<VisorCacheKeyConfiguration>();
        if (!F.isEmpty(cfgs)) {
            for (CacheKeyConfiguration cfg : cfgs) {
                res.add(new VisorCacheKeyConfiguration(cfg));
            }
        }
        return res;
    }

    public VisorCacheKeyConfiguration() {
    }

    public VisorCacheKeyConfiguration(CacheKeyConfiguration src) {
        this.typeName = src.getTypeName();
        this.affKeyFieldName = src.getAffinityKeyFieldName();
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getAffinityKeyFieldName() {
        return this.affKeyFieldName;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeString(out, this.typeName);
        U.writeString(out, this.affKeyFieldName);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.typeName = U.readString(in);
        this.affKeyFieldName = U.readString(in);
    }

    public String toString() {
        return S.toString(VisorCacheKeyConfiguration.class, this);
    }
}

