/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.performancestatistics.handlers;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.lang.invoke.LambdaMetafactory;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import org.apache.ignite.internal.performancestatistics.handlers.IgnitePerformanceStatisticsHandler;
import org.apache.ignite.internal.performancestatistics.util.Utils;
import org.apache.ignite.internal.processors.performancestatistics.OperationType;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheOperationsHandler
implements IgnitePerformanceStatisticsHandler {
    private static final String TOTAL = "total";
    private final Map<UUID, Map<Integer, Map<OperationType, Map<Long, IntWrapper>>>> res = new HashMap<UUID, Map<Integer, Map<OperationType, Map<Long, IntWrapper>>>>();

    @Override
    public void cacheOperation(UUID nodeId, OperationType type, int cacheId, long startTime, long duration) {
        UUID[] nodesId = new UUID[]{null, nodeId};
        int[] cacheIds = new int[]{0, cacheId};
        long aggrTime = startTime / 1000L * 1000L;
        for (UUID node : nodesId) {
            for (int cache : cacheIds) {
                ++this.res.computeIfAbsent((UUID)node, (Function<UUID, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$cacheOperation$0(java.util.UUID ), (Ljava/util/UUID;)Ljava/util/Map;)()).computeIfAbsent(Integer.valueOf((int)cache), (Function<Integer, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$cacheOperation$1(java.lang.Integer ), (Ljava/lang/Integer;)Ljava/util/Map;)()).computeIfAbsent(type, (Function<OperationType, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$cacheOperation$2(org.apache.ignite.internal.processors.performancestatistics.OperationType ), (Lorg/apache/ignite/internal/processors/performancestatistics/OperationType;)Ljava/util/Map;)()).computeIfAbsent(Long.valueOf((long)aggrTime), (Function<Long, IntWrapper>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$cacheOperation$3(java.lang.Long ), (Ljava/lang/Long;)Lorg/apache/ignite/internal/performancestatistics/handlers/CacheOperationsHandler$IntWrapper;)()).count;
            }
        }
    }

    @Override
    public Map<String, JsonNode> results() {
        ObjectNode jsonRes = Utils.MAPPER.createObjectNode();
        this.res.forEach((nodeId, cachesMap) -> {
            ObjectNode node = Utils.createObjectIfAbsent(nodeId == null ? TOTAL : String.valueOf(nodeId), jsonRes);
            cachesMap.forEach((cacheId, opsMap) -> {
                ObjectNode cache = Utils.createObjectIfAbsent(cacheId == 0 ? TOTAL : String.valueOf(cacheId), node);
                opsMap.forEach((opType, timingMap) -> {
                    ArrayNode op = Utils.createArrayIfAbsent(opType.toString(), cache);
                    timingMap.forEach((time, count) -> {
                        ArrayNode arr = Utils.MAPPER.createArrayNode();
                        arr.add(time);
                        arr.add(count.count);
                        op.add((JsonNode)arr);
                    });
                });
            });
        });
        return U.map((Object)"cacheOps", (Object)jsonRes);
    }

    private static /* synthetic */ IntWrapper lambda$cacheOperation$3(Long time) {
        return new IntWrapper();
    }

    private static /* synthetic */ Map lambda$cacheOperation$2(OperationType op) {
        return new HashMap();
    }

    private static /* synthetic */ Map lambda$cacheOperation$1(Integer id) {
        return new EnumMap(OperationType.class);
    }

    private static /* synthetic */ Map lambda$cacheOperation$0(UUID uuid) {
        return new HashMap();
    }

    public static class IntWrapper {
        public int count;
    }
}

