/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.tiles.features;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.attributes.AttributesRow;
import mil.nga.geopackage.extension.nga.style.FeatureStyle;
import mil.nga.geopackage.extension.nga.style.FeatureTableStyles;
import mil.nga.geopackage.extension.nga.style.IconCache;
import mil.nga.geopackage.extension.nga.style.IconDao;
import mil.nga.geopackage.extension.nga.style.IconRow;
import mil.nga.geopackage.extension.nga.style.StyleDao;
import mil.nga.geopackage.extension.nga.style.StyleRow;
import mil.nga.geopackage.features.index.FeatureIndexManager;
import mil.nga.geopackage.features.index.FeatureIndexResults;
import mil.nga.geopackage.features.user.FeatureDao;
import mil.nga.geopackage.features.user.FeatureResultSet;
import mil.nga.geopackage.features.user.FeatureRow;
import mil.nga.geopackage.features.user.FeatureTable;
import mil.nga.geopackage.property.GeoPackageJavaProperties;
import mil.nga.geopackage.style.PixelBounds;
import mil.nga.geopackage.tiles.ImageUtils;
import mil.nga.geopackage.tiles.TileBoundingBoxUtils;
import mil.nga.geopackage.tiles.TileUtils;
import mil.nga.geopackage.tiles.features.CustomFeaturesTile;
import mil.nga.geopackage.tiles.features.FeatureDrawType;
import mil.nga.geopackage.tiles.features.FeaturePaintCache;
import mil.nga.geopackage.tiles.features.FeatureTilePointIcon;
import mil.nga.geopackage.tiles.features.Paint;
import mil.nga.geopackage.user.custom.UserCustomRow;
import mil.nga.proj.Projection;
import mil.nga.proj.ProjectionFactory;
import mil.nga.sf.GeometryType;
import mil.nga.sf.Point;
import mil.nga.sf.proj.GeometryTransform;
import mil.nga.sf.util.GeometryUtils;
import org.locationtech.proj4j.units.Units;

public abstract class FeatureTiles {
    private static final Logger LOGGER = Logger.getLogger(FeatureTiles.class.getName());
    protected static final Projection WGS_84_PROJECTION = ProjectionFactory.getProjection((long)4326L);
    protected static final Projection WEB_MERCATOR_PROJECTION = ProjectionFactory.getProjection((long)3857L);
    protected final FeatureDao featureDao;
    protected Projection projection;
    protected FeatureIndexManager indexManager;
    protected FeatureTableStyles featureTableStyles;
    protected int tileWidth;
    protected int tileHeight;
    protected String compressFormat;
    protected float pointRadius;
    protected Paint pointPaint = new Paint();
    protected FeatureTilePointIcon pointIcon;
    protected Paint linePaint = new Paint();
    protected float lineStrokeWidth;
    protected Paint polygonPaint = new Paint();
    protected float polygonStrokeWidth;
    protected boolean fillPolygon;
    protected Paint polygonFillPaint = new Paint();
    private FeaturePaintCache featurePaintCache = new FeaturePaintCache();
    private IconCache iconCache = new IconCache();
    protected float heightOverlap;
    protected float widthOverlap;
    protected Integer maxFeaturesPerTile;
    protected CustomFeaturesTile maxFeaturesTileDraw;
    protected boolean simplifyGeometries = true;
    protected float scale = 1.0f;

    public FeatureTiles(FeatureDao featureDao) {
        this(null, featureDao);
    }

    public FeatureTiles(FeatureDao featureDao, float scale) {
        this(null, featureDao, scale);
    }

    public FeatureTiles(FeatureDao featureDao, int width, int height) {
        this(null, featureDao, width, height);
    }

    public FeatureTiles(GeoPackage geoPackage, FeatureDao featureDao) {
        this(geoPackage, featureDao, 512, 512);
    }

    public FeatureTiles(GeoPackage geoPackage, FeatureDao featureDao, float scale) {
        this(geoPackage, featureDao, scale, TileUtils.tileLength(scale), TileUtils.tileLength(scale));
    }

    public FeatureTiles(GeoPackage geoPackage, FeatureDao featureDao, int width, int height) {
        this(geoPackage, featureDao, TileUtils.tileScale(width, height), width, height);
    }

    public FeatureTiles(GeoPackage geoPackage, FeatureDao featureDao, float scale, int width, int height) {
        this.featureDao = featureDao;
        if (featureDao != null) {
            this.projection = featureDao.getProjection();
        }
        this.scale = scale;
        this.tileWidth = width;
        this.tileHeight = height;
        this.compressFormat = GeoPackageJavaProperties.getProperty("geopackage.feature_tiles", "compress_format");
        this.pointRadius = GeoPackageJavaProperties.getFloatProperty("geopackage.feature_tiles.point", "radius");
        this.pointPaint.setColor(GeoPackageJavaProperties.getColorProperty("geopackage.feature_tiles.point", "color"));
        this.lineStrokeWidth = GeoPackageJavaProperties.getFloatProperty("geopackage.feature_tiles.line", "stroke_width");
        this.linePaint.setStrokeWidth(Float.valueOf(this.scale * this.lineStrokeWidth));
        this.linePaint.setColor(GeoPackageJavaProperties.getColorProperty("geopackage.feature_tiles.line", "color"));
        this.polygonStrokeWidth = GeoPackageJavaProperties.getFloatProperty("geopackage.feature_tiles.polygon", "stroke_width");
        this.polygonPaint.setStrokeWidth(Float.valueOf(this.scale * this.polygonStrokeWidth));
        this.polygonPaint.setColor(GeoPackageJavaProperties.getColorProperty("geopackage.feature_tiles.polygon", "color"));
        this.fillPolygon = GeoPackageJavaProperties.getBooleanProperty("geopackage.feature_tiles.polygon_fill");
        this.polygonFillPaint.setColor(GeoPackageJavaProperties.getColorProperty("geopackage.feature_tiles.polygon_fill", "color"));
        if (geoPackage != null) {
            this.indexManager = new FeatureIndexManager(geoPackage, featureDao);
            if (!this.indexManager.isIndexed()) {
                this.indexManager.close();
                this.indexManager = null;
            }
            this.featureTableStyles = new FeatureTableStyles(geoPackage, (FeatureTable)featureDao.getTable());
            if (!this.featureTableStyles.has()) {
                this.featureTableStyles = null;
            }
        }
        this.calculateDrawOverlap();
    }

    public void close() {
        if (this.indexManager != null) {
            this.indexManager.close();
        }
    }

    public void calculateDrawOverlap() {
        if (this.pointIcon != null) {
            this.heightOverlap = this.scale * (float)this.pointIcon.getHeight();
            this.widthOverlap = this.scale * (float)this.pointIcon.getWidth();
        } else {
            this.heightOverlap = this.scale * this.pointRadius;
            this.widthOverlap = this.scale * this.pointRadius;
        }
        float linePaintHalfStroke = this.scale * this.lineStrokeWidth / 2.0f;
        this.heightOverlap = Math.max(this.heightOverlap, linePaintHalfStroke);
        this.widthOverlap = Math.max(this.widthOverlap, linePaintHalfStroke);
        float polygonPaintHalfStroke = this.scale * this.polygonStrokeWidth / 2.0f;
        this.heightOverlap = Math.max(this.heightOverlap, polygonPaintHalfStroke);
        this.widthOverlap = Math.max(this.widthOverlap, polygonPaintHalfStroke);
        if (this.featureTableStyles != null && this.featureTableStyles.has()) {
            List<Long> iconIds;
            List<Long> styleIds;
            HashSet<Long> styleRowIds = new HashSet<Long>();
            List<Long> tableStyleIds = this.featureTableStyles.getAllTableStyleIds();
            if (tableStyleIds != null) {
                styleRowIds.addAll(tableStyleIds);
            }
            if ((styleIds = this.featureTableStyles.getAllStyleIds()) != null) {
                styleRowIds.addAll(styleIds);
            }
            StyleDao styleDao = this.featureTableStyles.getStyleDao();
            Iterator iterator = styleRowIds.iterator();
            while (iterator.hasNext()) {
                long styleRowId = (Long)iterator.next();
                StyleRow styleRow = styleDao.getRow((AttributesRow)styleDao.queryForIdRow(styleRowId));
                float styleHalfWidth = this.scale * (float)(styleRow.getWidthOrDefault() / 2.0);
                this.widthOverlap = Math.max(this.widthOverlap, styleHalfWidth);
                this.heightOverlap = Math.max(this.heightOverlap, styleHalfWidth);
            }
            HashSet<Long> iconRowIds = new HashSet<Long>();
            List<Long> tableIconIds = this.featureTableStyles.getAllTableIconIds();
            if (tableIconIds != null) {
                iconRowIds.addAll(tableIconIds);
            }
            if ((iconIds = this.featureTableStyles.getAllIconIds()) != null) {
                iconRowIds.addAll(iconIds);
            }
            IconDao iconDao = this.featureTableStyles.getIconDao();
            Iterator iterator2 = iconRowIds.iterator();
            while (iterator2.hasNext()) {
                long iconRowId = (Long)iterator2.next();
                IconRow iconRow = iconDao.getRow((UserCustomRow)iconDao.queryForIdRow(iconRowId));
                double[] iconDimensions = iconRow.getDerivedDimensions();
                float iconWidth = this.scale * (float)Math.ceil(iconDimensions[0]);
                float iconHeight = this.scale * (float)Math.ceil(iconDimensions[1]);
                this.widthOverlap = Math.max(this.widthOverlap, iconWidth);
                this.heightOverlap = Math.max(this.heightOverlap, iconHeight);
            }
        }
    }

    public void setScale(float scale) {
        this.scale = scale;
        this.linePaint.setStrokeWidth(Float.valueOf(scale * this.lineStrokeWidth));
        this.polygonPaint.setStrokeWidth(Float.valueOf(scale * this.polygonStrokeWidth));
        this.featurePaintCache.clear();
    }

    public float getScale() {
        return this.scale;
    }

    public void setDrawOverlap(float pixels) {
        this.setWidthDrawOverlap(pixels);
        this.setHeightDrawOverlap(pixels);
    }

    public float getWidthDrawOverlap() {
        return this.widthOverlap;
    }

    public void setWidthDrawOverlap(float pixels) {
        this.widthOverlap = pixels;
    }

    public float getHeightDrawOverlap() {
        return this.heightOverlap;
    }

    public void setHeightDrawOverlap(float pixels) {
        this.heightOverlap = pixels;
    }

    public FeatureDao getFeatureDao() {
        return this.featureDao;
    }

    public boolean isIndexQuery() {
        return this.indexManager != null && this.indexManager.isIndexed();
    }

    public FeatureIndexManager getIndexManager() {
        return this.indexManager;
    }

    public void setIndexManager(FeatureIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public FeatureTableStyles getFeatureTableStyles() {
        return this.featureTableStyles;
    }

    public void setFeatureTableStyles(FeatureTableStyles featureTableStyles) {
        this.featureTableStyles = featureTableStyles;
    }

    public void ignoreFeatureTableStyles() {
        this.setFeatureTableStyles(null);
        this.calculateDrawOverlap();
    }

    public void clearCache() {
        this.clearStylePaintCache();
        this.clearIconCache();
    }

    public void clearStylePaintCache() {
        this.featurePaintCache.clear();
    }

    public void setStylePaintCacheSize(int size) {
        this.featurePaintCache.resize(size);
    }

    public void clearIconCache() {
        this.iconCache.clear();
    }

    public void setIconCacheSize(int size) {
        this.iconCache.resize(size);
    }

    public int getTileWidth() {
        return this.tileWidth;
    }

    public void setTileWidth(int tileWidth) {
        this.tileWidth = tileWidth;
    }

    public int getTileHeight() {
        return this.tileHeight;
    }

    public void setTileHeight(int tileHeight) {
        this.tileHeight = tileHeight;
    }

    public String getCompressFormat() {
        return this.compressFormat;
    }

    public void setCompressFormat(String compressFormat) {
        this.compressFormat = compressFormat;
    }

    public float getPointRadius() {
        return this.pointRadius;
    }

    public void setPointRadius(float pointRadius) {
        this.pointRadius = pointRadius;
    }

    public Color getPointColor() {
        return this.pointPaint.getColor();
    }

    public void setPointColor(Color pointColor) {
        this.pointPaint.setColor(pointColor);
    }

    public FeatureTilePointIcon getPointIcon() {
        return this.pointIcon;
    }

    public void setPointIcon(FeatureTilePointIcon pointIcon) {
        this.pointIcon = pointIcon;
    }

    public float getLineStrokeWidth() {
        return this.lineStrokeWidth;
    }

    public void setLineStrokeWidth(float lineStrokeWidth) {
        this.lineStrokeWidth = lineStrokeWidth;
        this.linePaint.setStrokeWidth(Float.valueOf(this.scale * lineStrokeWidth));
    }

    public Color getLineColor() {
        return this.linePaint.getColor();
    }

    public void setLineColor(Color lineColor) {
        this.linePaint.setColor(lineColor);
    }

    public float getPolygonStrokeWidth() {
        return this.polygonStrokeWidth;
    }

    public void setPolygonStrokeWidth(float polygonStrokeWidth) {
        this.polygonStrokeWidth = polygonStrokeWidth;
        this.polygonPaint.setStrokeWidth(Float.valueOf(this.scale * polygonStrokeWidth));
    }

    public Color getPolygonColor() {
        return this.polygonPaint.getColor();
    }

    public void setPolygonColor(Color polygonColor) {
        this.polygonPaint.setColor(polygonColor);
    }

    public boolean isFillPolygon() {
        return this.fillPolygon;
    }

    public void setFillPolygon(boolean fillPolygon) {
        this.fillPolygon = fillPolygon;
    }

    public Color getPolygonFillColor() {
        return this.polygonFillPaint.getColor();
    }

    public void setPolygonFillColor(Color polygonFillColor) {
        this.polygonFillPaint.setColor(polygonFillColor);
    }

    public Integer getMaxFeaturesPerTile() {
        return this.maxFeaturesPerTile;
    }

    public void setMaxFeaturesPerTile(Integer maxFeaturesPerTile) {
        this.maxFeaturesPerTile = maxFeaturesPerTile;
    }

    public CustomFeaturesTile getMaxFeaturesTileDraw() {
        return this.maxFeaturesTileDraw;
    }

    public void setMaxFeaturesTileDraw(CustomFeaturesTile maxFeaturesTileDraw) {
        this.maxFeaturesTileDraw = maxFeaturesTileDraw;
    }

    public boolean isSimplifyGeometries() {
        return this.simplifyGeometries;
    }

    public void setSimplifyGeometries(boolean simplifyGeometries) {
        this.simplifyGeometries = simplifyGeometries;
    }

    public byte[] drawTileBytes(int x, int y, int zoom) {
        BufferedImage image = this.drawTile(x, y, zoom);
        byte[] tileData = null;
        if (image != null) {
            try {
                tileData = ImageUtils.writeImageToBytes(image, this.compressFormat);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "Failed to create tile. x: " + x + ", y: " + y + ", zoom: " + zoom, e);
            }
        }
        return tileData;
    }

    public BufferedImage drawTile(int x, int y, int zoom) {
        BufferedImage image = this.isIndexQuery() ? this.drawTileQueryIndex(x, y, zoom) : this.drawTileQueryAll(x, y, zoom);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage drawTileQueryIndex(int x, int y, int zoom) {
        BoundingBox webMercatorBoundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox((long)x, (long)y, (long)zoom);
        BufferedImage image = null;
        long tileCount = this.queryIndexedFeaturesCount(webMercatorBoundingBox);
        if (tileCount > 0L) {
            try (FeatureIndexResults results = this.queryIndexedFeatures(webMercatorBoundingBox);){
                if (this.maxFeaturesPerTile == null || tileCount <= this.maxFeaturesPerTile.longValue()) {
                    image = this.drawTile(zoom, webMercatorBoundingBox, results);
                } else if (this.maxFeaturesTileDraw != null) {
                    image = this.maxFeaturesTileDraw.drawTile(this.tileWidth, this.tileHeight, tileCount, results);
                }
            }
        }
        return image;
    }

    public long queryIndexedFeaturesCount(int x, int y, int zoom) {
        BoundingBox webMercatorBoundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox((long)x, (long)y, (long)zoom);
        long count = this.queryIndexedFeaturesCount(webMercatorBoundingBox);
        return count;
    }

    public long queryIndexedFeaturesCount(BoundingBox webMercatorBoundingBox) {
        BoundingBox expandedQueryBoundingBox = this.expandBoundingBox(webMercatorBoundingBox);
        long count = this.indexManager.count(expandedQueryBoundingBox, WEB_MERCATOR_PROJECTION);
        return count;
    }

    public FeatureIndexResults queryIndexedFeatures(int x, int y, int zoom) {
        BoundingBox webMercatorBoundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox((long)x, (long)y, (long)zoom);
        return this.queryIndexedFeatures(webMercatorBoundingBox);
    }

    public FeatureIndexResults queryIndexedFeatures(BoundingBox webMercatorBoundingBox) {
        BoundingBox expandedQueryBoundingBox = this.expandBoundingBox(webMercatorBoundingBox);
        FeatureIndexResults results = this.indexManager.query(expandedQueryBoundingBox, WEB_MERCATOR_PROJECTION);
        return results;
    }

    public BoundingBox expandBoundingBox(BoundingBox boundingBox, Projection projection) {
        BoundingBox expandedBoundingBox = boundingBox;
        GeometryTransform toWebMercator = GeometryTransform.create((Projection)projection, (long)3857L);
        if (!toWebMercator.isSameProjection()) {
            expandedBoundingBox = expandedBoundingBox.transform(toWebMercator);
        }
        expandedBoundingBox = this.expandBoundingBox(expandedBoundingBox);
        if (!toWebMercator.isSameProjection()) {
            GeometryTransform fromWebMercator = toWebMercator.getInverseTransformation();
            expandedBoundingBox = expandedBoundingBox.transform(fromWebMercator);
        }
        return expandedBoundingBox;
    }

    public BoundingBox expandBoundingBox(BoundingBox webMercatorBoundingBox) {
        return this.expandBoundingBox(webMercatorBoundingBox, webMercatorBoundingBox);
    }

    public BoundingBox expandBoundingBox(BoundingBox webMercatorBoundingBox, BoundingBox tileWebMercatorBoundingBox) {
        double minLongitude = TileBoundingBoxUtils.getLongitudeFromPixel((long)this.tileWidth, (BoundingBox)webMercatorBoundingBox, (BoundingBox)tileWebMercatorBoundingBox, (float)(0.0f - this.widthOverlap));
        double maxLongitude = TileBoundingBoxUtils.getLongitudeFromPixel((long)this.tileWidth, (BoundingBox)webMercatorBoundingBox, (BoundingBox)tileWebMercatorBoundingBox, (float)((float)this.tileWidth + this.widthOverlap));
        double maxLatitude = TileBoundingBoxUtils.getLatitudeFromPixel((long)this.tileHeight, (BoundingBox)webMercatorBoundingBox, (BoundingBox)tileWebMercatorBoundingBox, (float)(0.0f - this.heightOverlap));
        double minLatitude = TileBoundingBoxUtils.getLatitudeFromPixel((long)this.tileHeight, (BoundingBox)webMercatorBoundingBox, (BoundingBox)tileWebMercatorBoundingBox, (float)((float)this.tileHeight + this.heightOverlap));
        minLongitude = Math.min(minLongitude, webMercatorBoundingBox.getMinLongitude());
        maxLongitude = Math.max(maxLongitude, webMercatorBoundingBox.getMaxLongitude());
        minLatitude = Math.min(minLatitude, webMercatorBoundingBox.getMinLatitude());
        maxLatitude = Math.max(maxLatitude, webMercatorBoundingBox.getMaxLatitude());
        BoundingBox expandedBoundingBox = new BoundingBox(minLongitude, minLatitude, maxLongitude, maxLatitude);
        expandedBoundingBox = TileBoundingBoxUtils.boundWebMercatorBoundingBox((BoundingBox)expandedBoundingBox);
        return expandedBoundingBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage drawTileQueryAll(int x, int y, int zoom) {
        BoundingBox boundingBox = TileBoundingBoxUtils.getWebMercatorBoundingBox((long)x, (long)y, (long)zoom);
        BufferedImage image = null;
        try (FeatureResultSet resultSet = (FeatureResultSet)this.featureDao.queryForAll();){
            int totalCount = resultSet.getCount();
            if (totalCount > 0) {
                if (this.maxFeaturesPerTile == null || totalCount <= this.maxFeaturesPerTile) {
                    image = this.drawTile(zoom, boundingBox, resultSet);
                } else if (this.maxFeaturesTileDraw != null) {
                    image = this.maxFeaturesTileDraw.drawUnindexedTile(this.tileWidth, this.tileHeight, totalCount, resultSet);
                }
            }
        }
        return image;
    }

    protected BufferedImage createNewImage() {
        return new BufferedImage(this.tileWidth, this.tileHeight, 2);
    }

    protected Graphics2D getGraphics(BufferedImage image) {
        Graphics2D graphics = image.createGraphics();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return graphics;
    }

    protected GeometryTransform getWebMercatorTransform() {
        return GeometryTransform.create((Projection)this.featureDao.getProjection(), (long)3857L);
    }

    protected List<Point> simplifyPoints(double simplifyTolerance, List<Point> points) {
        List simplifiedPoints = null;
        if (this.simplifyGeometries) {
            if (this.projection != null && !this.projection.isUnit(Units.METRES)) {
                GeometryTransform toWebMercator = GeometryTransform.create((Projection)this.projection, (Projection)WEB_MERCATOR_PROJECTION);
                points = toWebMercator.transform(points);
            }
            simplifiedPoints = GeometryUtils.simplifyPoints(points, (double)simplifyTolerance);
            if (this.projection != null && !this.projection.isUnit(Units.METRES)) {
                GeometryTransform fromWebMercator = GeometryTransform.create((Projection)WEB_MERCATOR_PROJECTION, (Projection)this.projection);
                simplifiedPoints = fromWebMercator.transform(simplifiedPoints);
            }
        } else {
            simplifiedPoints = points;
        }
        return simplifiedPoints;
    }

    protected FeatureStyle getFeatureStyle(FeatureRow featureRow) {
        FeatureStyle featureStyle = null;
        if (this.featureTableStyles != null) {
            featureStyle = this.featureTableStyles.getFeatureStyle(featureRow);
        }
        return featureStyle;
    }

    protected FeatureStyle getFeatureStyle(FeatureRow featureRow, GeometryType geometryType) {
        FeatureStyle featureStyle = null;
        if (this.featureTableStyles != null) {
            featureStyle = this.featureTableStyles.getFeatureStyle(featureRow, geometryType);
        }
        return featureStyle;
    }

    protected BufferedImage getIcon(IconRow iconRow) {
        return this.iconCache.createIcon(iconRow, this.scale);
    }

    protected Paint getPointPaint(FeatureStyle featureStyle) {
        Paint paint = this.getFeatureStylePaint(featureStyle, FeatureDrawType.CIRCLE);
        if (paint == null) {
            paint = this.pointPaint;
        }
        return paint;
    }

    protected Paint getLinePaint(FeatureStyle featureStyle) {
        Paint paint = this.getFeatureStylePaint(featureStyle, FeatureDrawType.STROKE);
        if (paint == null) {
            paint = this.linePaint;
        }
        return paint;
    }

    protected Paint getPolygonPaint(FeatureStyle featureStyle) {
        Paint paint = this.getFeatureStylePaint(featureStyle, FeatureDrawType.STROKE);
        if (paint == null) {
            paint = this.polygonPaint;
        }
        return paint;
    }

    protected Paint getPolygonFillPaint(FeatureStyle featureStyle) {
        StyleRow style;
        Paint paint = null;
        boolean hasStyleColor = false;
        if (featureStyle != null && (style = featureStyle.getStyle()) != null) {
            if (style.hasFillColor()) {
                paint = this.getStylePaint(style, FeatureDrawType.FILL);
            } else {
                hasStyleColor = style.hasColor();
            }
        }
        if (paint == null && !hasStyleColor && this.fillPolygon) {
            paint = this.polygonFillPaint;
        }
        return paint;
    }

    private Paint getFeatureStylePaint(FeatureStyle featureStyle, FeatureDrawType drawType) {
        StyleRow style;
        Paint paint = null;
        if (featureStyle != null && (style = featureStyle.getStyle()) != null && style.hasColor()) {
            paint = this.getStylePaint(style, drawType);
        }
        return paint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Paint getStylePaint(StyleRow style, FeatureDrawType drawType) {
        Paint paint = this.featurePaintCache.getPaint(style, drawType);
        if (paint == null) {
            mil.nga.color.Color color = null;
            Float strokeWidth = null;
            switch (drawType) {
                case CIRCLE: {
                    color = style.getColorOrDefault();
                    break;
                }
                case STROKE: {
                    color = style.getColorOrDefault();
                    strokeWidth = Float.valueOf(this.scale * (float)style.getWidthOrDefault());
                    break;
                }
                case FILL: {
                    color = style.getFillColor();
                    strokeWidth = Float.valueOf(this.scale * (float)style.getWidthOrDefault());
                    break;
                }
                default: {
                    throw new GeoPackageException("Unsupported Draw Type: " + drawType);
                }
            }
            Paint stylePaint = new Paint();
            stylePaint.setColor(new Color(color.getColorWithAlpha(), true));
            if (strokeWidth != null) {
                stylePaint.setStrokeWidth(strokeWidth);
            }
            FeaturePaintCache featurePaintCache = this.featurePaintCache;
            synchronized (featurePaintCache) {
                paint = this.featurePaintCache.getPaint(style, drawType);
                if (paint == null) {
                    this.featurePaintCache.setPaint(style, drawType, stylePaint);
                    paint = stylePaint;
                }
            }
        }
        return paint;
    }

    protected boolean isTransparent(BufferedImage image) {
        WritableRaster raster;
        boolean transparent = false;
        if (image != null && (raster = image.getAlphaRaster()) != null) {
            transparent = true;
            block0: for (int x = 0; x < image.getWidth(); ++x) {
                for (int y = 0; y < image.getHeight(); ++y) {
                    if (raster.getSample(x, y, 0) <= 0) continue;
                    transparent = false;
                    break block0;
                }
            }
        }
        return transparent;
    }

    protected BufferedImage checkIfDrawn(BufferedImage image) {
        if (this.isTransparent(image)) {
            image = null;
        }
        return image;
    }

    public PixelBounds calculateStylePixelBounds() {
        return this.calculateStylePixelBounds(this.scale);
    }

    public PixelBounds calculateStylePixelBounds(float scale) {
        PixelBounds pixelBounds = null;
        if (this.featureTableStyles != null) {
            pixelBounds = this.featureTableStyles.calculatePixelBounds(scale);
        }
        return pixelBounds;
    }

    public abstract BufferedImage drawTile(int var1, BoundingBox var2, FeatureIndexResults var3);

    public abstract BufferedImage drawTile(int var1, BoundingBox var2, FeatureResultSet var3);

    public abstract BufferedImage drawTile(int var1, BoundingBox var2, List<FeatureRow> var3);
}

