/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldExistsQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.Weight;

public class IndexSortSortedNumericDocValuesRangeQuery
extends Query {
    private final String field;
    private final long lowerValue;
    private final long upperValue;
    private final Query fallbackQuery;

    public IndexSortSortedNumericDocValuesRangeQuery(String field, long lowerValue, long upperValue, Query fallbackQuery) {
        this.field = Objects.requireNonNull(field);
        this.lowerValue = lowerValue;
        this.upperValue = upperValue;
        this.fallbackQuery = fallbackQuery;
    }

    public Query getFallbackQuery() {
        return this.fallbackQuery;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        IndexSortSortedNumericDocValuesRangeQuery that = (IndexSortSortedNumericDocValuesRangeQuery)((Object)o);
        return this.lowerValue == that.lowerValue && this.upperValue == that.upperValue && Objects.equals(this.field, that.field) && Objects.equals(this.fallbackQuery, that.fallbackQuery);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.lowerValue, this.upperValue, this.fallbackQuery);
    }

    public void visit(QueryVisitor visitor) {
        if (visitor.acceptField(this.field)) {
            visitor.visitLeaf((Query)this);
            this.fallbackQuery.visit(visitor);
        }
    }

    public String toString(String field) {
        StringBuilder b = new StringBuilder();
        if (!this.field.equals(field)) {
            b.append(this.field).append(":");
        }
        return b.append("[").append(this.lowerValue).append(" TO ").append(this.upperValue).append("]").toString();
    }

    public Query rewrite(IndexReader reader) throws IOException {
        if (this.lowerValue == Long.MIN_VALUE && this.upperValue == Long.MAX_VALUE) {
            return new FieldExistsQuery(this.field);
        }
        Query rewrittenFallback = this.fallbackQuery.rewrite(reader);
        if (rewrittenFallback.getClass() == MatchAllDocsQuery.class) {
            return new MatchAllDocsQuery();
        }
        if (rewrittenFallback == this.fallbackQuery) {
            return this;
        }
        return new IndexSortSortedNumericDocValuesRangeQuery(this.field, this.lowerValue, this.upperValue, rewrittenFallback);
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        final Weight fallbackWeight = this.fallbackQuery.createWeight(searcher, scoreMode, boost);
        return new ConstantScoreWeight(this, boost){

            public ScorerSupplier scorerSupplier(LeafReaderContext context) throws IOException {
                1 weight = this;
                BoundedDocIdSetIterator disi = IndexSortSortedNumericDocValuesRangeQuery.this.getDocIdSetIteratorOrNull(context);
                if (disi != null) {
                    return new ScorerSupplier((Weight)weight, disi){
                        final /* synthetic */ Weight val$weight;
                        final /* synthetic */ DocIdSetIterator val$disi;
                        {
                            this.val$weight = weight;
                            this.val$disi = docIdSetIterator;
                        }

                        public Scorer get(long leadCost) throws IOException {
                            return new ConstantScoreScorer(this.val$weight, this.score(), scoreMode, this.val$disi);
                        }

                        public long cost() {
                            return this.val$disi.cost();
                        }
                    };
                }
                return fallbackWeight.scorerSupplier(context);
            }

            public Scorer scorer(LeafReaderContext context) throws IOException {
                ScorerSupplier scorerSupplier = this.scorerSupplier(context);
                if (scorerSupplier == null) {
                    return null;
                }
                return scorerSupplier.get(Long.MAX_VALUE);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return fallbackWeight.isCacheable(ctx);
            }

            public int count(LeafReaderContext context) throws IOException {
                BoundedDocIdSetIterator disi;
                if (!context.reader().hasDeletions() && (disi = IndexSortSortedNumericDocValuesRangeQuery.this.getDocIdSetIteratorOrNull(context)) != null && disi.delegate == null) {
                    return disi.lastDoc - disi.firstDoc;
                }
                return fallbackWeight.count(context);
            }
        };
    }

    private BoundedDocIdSetIterator getDocIdSetIteratorOrNull(LeafReaderContext context) throws IOException {
        SortField sortField;
        SortField.Type sortFieldType;
        Sort indexSort;
        SortedNumericDocValues sortedNumericValues = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)this.field);
        NumericDocValues numericValues = DocValues.unwrapSingleton((SortedNumericDocValues)sortedNumericValues);
        if (numericValues != null && (indexSort = context.reader().getMetaData().getSort()) != null && indexSort.getSort().length > 0 && indexSort.getSort()[0].getField().equals(this.field) && ((sortFieldType = IndexSortSortedNumericDocValuesRangeQuery.getSortFieldType(sortField = indexSort.getSort()[0])) == SortField.Type.INT || sortFieldType == SortField.Type.LONG)) {
            return this.getDocIdSetIterator(sortField, sortFieldType, context, (DocIdSetIterator)numericValues);
        }
        return null;
    }

    private BoundedDocIdSetIterator getDocIdSetIterator(SortField sortField, SortField.Type sortFieldType, LeafReaderContext context, DocIdSetIterator delegate) throws IOException {
        long lower = sortField.getReverse() ? this.upperValue : this.lowerValue;
        long upper = sortField.getReverse() ? this.lowerValue : this.upperValue;
        int maxDoc = context.reader().maxDoc();
        ValueComparator comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, sortFieldType, lower, context);
        int low = 0;
        int high = maxDoc - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (comparator.compare(mid) <= 0) {
                high = mid - 1;
                comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, sortFieldType, lower, context);
                continue;
            }
            low = mid + 1;
        }
        int firstDocIdInclusive = high + 1;
        comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, sortFieldType, upper, context);
        low = firstDocIdInclusive;
        high = maxDoc - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (comparator.compare(mid) < 0) {
                high = mid - 1;
                comparator = IndexSortSortedNumericDocValuesRangeQuery.loadComparator(sortField, sortFieldType, upper, context);
                continue;
            }
            low = mid + 1;
        }
        int lastDocIdExclusive = high + 1;
        Object missingValue = sortField.getMissingValue();
        LeafReader reader = context.reader();
        PointValues pointValues = reader.getPointValues(this.field);
        long missingLongValue = missingValue == null ? 0L : (Long)missingValue;
        BoundedDocIdSetIterator disi = pointValues != null && pointValues.getDocCount() == reader.maxDoc() || missingLongValue < this.lowerValue || missingLongValue > this.upperValue ? new BoundedDocIdSetIterator(firstDocIdInclusive, lastDocIdExclusive, null) : new BoundedDocIdSetIterator(firstDocIdInclusive, lastDocIdExclusive, delegate);
        return disi;
    }

    private static ValueComparator loadComparator(SortField sortField, SortField.Type type, long topValue, LeafReaderContext context) throws IOException {
        FieldComparator fieldComparator = sortField.getComparator(1, false);
        if (type == SortField.Type.INT) {
            fieldComparator.setTopValue((Object)((int)topValue));
        } else {
            fieldComparator.setTopValue((Object)topValue);
        }
        LeafFieldComparator leafFieldComparator = fieldComparator.getLeafComparator(context);
        int direction = sortField.getReverse() ? -1 : 1;
        return doc -> {
            int value = leafFieldComparator.compareTop(doc);
            return direction * value;
        };
    }

    private static SortField.Type getSortFieldType(SortField sortField) {
        if (sortField instanceof SortedNumericSortField) {
            return ((SortedNumericSortField)sortField).getNumericType();
        }
        return sortField.getType();
    }

    private static class BoundedDocIdSetIterator
    extends DocIdSetIterator {
        private final int firstDoc;
        private final int lastDoc;
        private final DocIdSetIterator delegate;
        private int docID = -1;

        BoundedDocIdSetIterator(int firstDoc, int lastDoc, DocIdSetIterator delegate) {
            this.firstDoc = firstDoc;
            this.lastDoc = lastDoc;
            this.delegate = delegate;
        }

        public int docID() {
            return this.docID;
        }

        public int nextDoc() throws IOException {
            return this.advance(this.docID + 1);
        }

        public int advance(int target) throws IOException {
            if (target < this.firstDoc) {
                target = this.firstDoc;
            }
            int result = this.delegate != null ? this.delegate.advance(target) : target;
            this.docID = result < this.lastDoc ? result : Integer.MAX_VALUE;
            return this.docID;
        }

        public long cost() {
            return this.lastDoc - this.firstDoc;
        }
    }

    private static interface ValueComparator {
        public int compare(int var1) throws IOException;
    }
}

