/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Size;

@ApiModel(description="Begin and end times of the temporal extent.")
public class ExtentTemporal {
    @Valid
    private List<List<Date>> interval = new ArrayList<List<Date>>();
    @Valid
    private TrsEnum trs = TrsEnum.HTTP_WWW_OPENGIS_NET_DEF_UOM_ISO_8601_0_GREGORIAN;

    public ExtentTemporal interval(List<List<Date>> interval) {
        this.interval = interval;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="interval")
    @Size(min=1)
    public @Size(min=1) List<List<Date>> getInterval() {
        return this.interval;
    }

    public void setInterval(List<List<Date>> interval) {
        this.interval = interval;
    }

    public ExtentTemporal trs(TrsEnum trs) {
        this.trs = trs;
        return this;
    }

    @ApiModelProperty(value="Temporal reference system of the coordinates in the temporal extent (property `temporal`). Only the Gregorian calendar is supported by API-Collections. Extensions may support additional temporal reference systems.")
    @JsonProperty(value="trs")
    public TrsEnum getTrs() {
        return this.trs;
    }

    public void setTrs(TrsEnum trs) {
        this.trs = trs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtentTemporal extentTemporal = (ExtentTemporal)o;
        return Objects.equals(this.interval, extentTemporal.interval) && Objects.equals((Object)this.trs, (Object)extentTemporal.trs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.trs});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExtentTemporal {\n");
        sb.append("    interval: ").append(this.toIndentedString(this.interval)).append("\n");
        sb.append("    trs: ").append(this.toIndentedString((Object)this.trs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum TrsEnum {
        HTTP_WWW_OPENGIS_NET_DEF_UOM_ISO_8601_0_GREGORIAN(String.valueOf("http://www.opengis.net/def/uom/ISO-8601/0/Gregorian"));

        private String value;

        private TrsEnum(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        @JsonValue
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static TrsEnum fromValue(String value) {
            for (TrsEnum b : TrsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

