/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.storage.shapefile;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.baremaps.feature.Feature;
import org.apache.baremaps.feature.FeatureType;
import org.apache.baremaps.feature.ReadableFeatureSet;
import org.apache.baremaps.storage.shapefile.internal.InputFeatureStream;
import org.apache.baremaps.storage.shapefile.internal.ShapefileReader;

public class ShapefileFeatureSet
implements ReadableFeatureSet,
AutoCloseable {
    private final ShapefileReader shapeFile;

    public ShapefileFeatureSet(Path file) {
        this.shapeFile = new ShapefileReader(file.toString());
    }

    @Override
    public FeatureType getType() throws IOException {
        try (InputFeatureStream input = this.shapeFile.read();){
            FeatureType featureType = input.getFeaturesType();
            return featureType;
        }
    }

    public Stream<Feature> read() throws IOException {
        return StreamSupport.stream(new FeatureSpliterator(this.shapeFile.read()), false);
    }

    @Override
    public void close() throws Exception {
    }

    static class FeatureSpliterator
    implements Spliterator<Feature> {
        private final InputFeatureStream inputFeatureStream;

        public FeatureSpliterator(InputFeatureStream inputFeatureStream) {
            this.inputFeatureStream = inputFeatureStream;
        }

        @Override
        public boolean tryAdvance(Consumer<? super Feature> action) {
            try {
                Feature feature = this.inputFeatureStream.readFeature();
                if (feature != null) {
                    action.accept(feature);
                    return true;
                }
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public Spliterator<Feature> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 0;
        }
    }
}

