/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.cli.map;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.benmanes.caffeine.cache.CaffeineSpec;
import com.zaxxer.hikari.HikariDataSource;
import io.servicetalk.data.jackson.jersey.ServiceTalkJacksonSerializerFeature;
import io.servicetalk.http.api.BlockingStreamingHttpService;
import io.servicetalk.http.api.HttpServerContext;
import io.servicetalk.http.netty.HttpServers;
import io.servicetalk.http.router.jersey.HttpJerseyRouterBuilder;
import java.nio.file.Path;
import java.util.concurrent.Callable;
import javax.sql.DataSource;
import javax.ws.rs.core.Application;
import org.apache.baremaps.cli.Options;
import org.apache.baremaps.database.PostgresUtils;
import org.apache.baremaps.database.tile.PostgresTileStore;
import org.apache.baremaps.database.tile.TileCache;
import org.apache.baremaps.database.tile.TileStore;
import org.apache.baremaps.mvt.tileset.Tileset;
import org.apache.baremaps.server.ConfigReader;
import org.apache.baremaps.server.CorsFilter;
import org.apache.baremaps.server.DefaultObjectMapper;
import org.apache.baremaps.server.ServerResources;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="serve", description={"Start a tile server with caching capabilities."})
public class Serve
implements Callable<Integer> {
    private static final Logger logger = LoggerFactory.getLogger(Serve.class);
    @CommandLine.Mixin
    private Options options;
    @CommandLine.Option(names={"--database"}, paramLabel="DATABASE", description={"The JDBC url of Postgres."}, required=true)
    private String database;
    @CommandLine.Option(names={"--cache"}, paramLabel="CACHE", description={"The caffeine cache directive."})
    private String cache = "";
    @CommandLine.Option(names={"--tileset"}, paramLabel="TILESET", description={"The tileset file."}, required=true)
    private Path tileset;
    @CommandLine.Option(names={"--style"}, paramLabel="STYLE", description={"The style file."}, required=true)
    private Path style;
    @CommandLine.Option(names={"--host"}, paramLabel="HOST", description={"The host of the server."})
    private String host = "localhost";
    @CommandLine.Option(names={"--port"}, paramLabel="PORT", description={"The port of the server."})
    private int port = 9000;

    @Override
    public Integer call() throws Exception {
        final ObjectMapper objectMapper = DefaultObjectMapper.defaultObjectMapper();
        ConfigReader configReader = new ConfigReader();
        Tileset tileset = (Tileset)objectMapper.readValue(configReader.read(this.tileset), Tileset.class);
        CaffeineSpec caffeineSpec = CaffeineSpec.parse((String)this.cache);
        HikariDataSource datasource = PostgresUtils.dataSource((String)this.database);
        PostgresTileStore tileStore = new PostgresTileStore((DataSource)datasource, tileset);
        final TileCache tileCache = new TileCache((TileStore)tileStore, caffeineSpec);
        ResourceConfig application = new ResourceConfig().register(CorsFilter.class).register(ServerResources.class).register((Object)ServiceTalkJacksonSerializerFeature.contextResolverFor((ObjectMapper)objectMapper)).register((Object)new AbstractBinder(){

            protected void configure() {
                this.bind(Serve.this.tileset).to(Path.class).named("tileset");
                this.bind(Serve.this.style).to(Path.class).named("style");
                this.bind(tileCache).to(TileStore.class);
                this.bind(objectMapper).to(ObjectMapper.class);
            }
        });
        BlockingStreamingHttpService httpService = new HttpJerseyRouterBuilder().buildBlockingStreaming((Application)application);
        HttpServerContext serverContext = HttpServers.forPort((int)this.port).listenBlockingStreamingAndAwait(httpService);
        logger.info("Listening on {}", (Object)serverContext.listenAddress());
        serverContext.awaitShutdown();
        return 0;
    }
}

