/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.transport.netty.internal;

import io.netty.channel.Channel;
import io.netty.channel.EventLoop;
import io.netty.util.ReferenceCounted;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.internal.SubscribablePublisher;
import io.servicetalk.concurrent.internal.DuplicateSubscribeException;
import io.servicetalk.concurrent.internal.FlowControlUtils;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.concurrent.internal.TerminalNotification;
import io.servicetalk.transport.netty.internal.ChannelCloseUtils;
import io.servicetalk.transport.netty.internal.CloseHandler;
import io.servicetalk.transport.netty.internal.StacklessClosedChannelException;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class NettyChannelPublisher<T>
extends SubscribablePublisher<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NettyChannelPublisher.class);
    private long requestCount;
    private boolean requested;
    @Nullable
    private SubscriptionImpl subscription;
    @Nullable
    private Queue<Object> pending;
    @Nullable
    private Throwable fatalError;
    private final Channel channel;
    private final CloseHandler closeHandler;
    private final EventLoop eventLoop;

    NettyChannelPublisher(Channel channel, CloseHandler closeHandler) {
        this.eventLoop = channel.eventLoop();
        this.channel = channel;
        this.closeHandler = closeHandler;
    }

    protected void handleSubscribe(PublisherSource.Subscriber<? super T> nextSubscriber) {
        if (this.eventLoop.inEventLoop()) {
            this.subscribe0(nextSubscriber);
        } else {
            this.eventLoop.execute(() -> this.subscribe0(nextSubscriber));
        }
    }

    void channelRead(T data) {
        this.assertInEventloop();
        if (data instanceof ReferenceCounted) {
            this.channelReadReferenceCounted((ReferenceCounted)data);
            return;
        }
        if (this.fatalError != null) {
            return;
        }
        if (this.subscription == null || this.shouldBuffer()) {
            this.addPending(data);
            if (this.subscription != null) {
                this.processPending(this.subscription);
            }
        } else {
            this.emit(this.subscription, data);
        }
    }

    void channelOnComplete() {
        this.assertInEventloop();
        if (this.fatalError != null) {
            return;
        }
        if (this.subscription == null || this.hasQueuedSignals()) {
            this.addPending(TerminalNotification.complete());
            if (this.subscription != null) {
                this.processPending(this.subscription);
            }
        } else {
            this.emitComplete(this.subscription);
        }
    }

    void channelOnError(Throwable throwable) {
        this.assertInEventloop();
        if (this.fatalError == null) {
            this.fatalError = throwable instanceof ClosedChannelException ? throwable : StacklessClosedChannelException.newInstance(NettyChannelPublisher.class, "channelOnError").initCause(throwable);
            this.channelOnError0(throwable);
        }
    }

    private void channelOnError0(Throwable throwable) {
        ChannelCloseUtils.assignConnectionError(this.channel, throwable);
        if (this.subscription == null) {
            this.closeChannelInbound();
            if (this.hasQueuedSignals()) {
                this.addPending(TerminalNotification.error((Throwable)throwable));
            }
        } else if (this.hasQueuedSignals()) {
            this.addPending(TerminalNotification.error((Throwable)throwable));
            this.processPending(this.subscription);
        } else {
            this.emitError(this.subscription, throwable);
        }
    }

    private void channelReadReferenceCounted(ReferenceCounted data) {
        try {
            data.release();
        }
        finally {
            this.emitCatchError(this.subscription, new IllegalArgumentException("Reference counted leaked netty's pipeline. Object: " + data.getClass().getSimpleName()), true);
        }
    }

    void onReadComplete() {
        this.assertInEventloop();
        this.requested = false;
        if (this.requestCount > 0L) {
            this.requestChannel();
        }
    }

    private void requestN(long n, SubscriptionImpl forSubscription) {
        if (forSubscription != this.subscription) {
            return;
        }
        if (SubscriberUtils.isRequestNValid((long)n)) {
            this.requestCount = FlowControlUtils.addWithOverflowProtection((long)this.requestCount, (long)n);
            if (!this.processPending(forSubscription) && !this.requested && this.requestCount > 0L) {
                this.requestChannel();
            }
        } else {
            this.resetSubscription();
            IllegalArgumentException cause = SubscriberUtils.newExceptionForInvalidRequestN((long)n);
            forSubscription.associatedSub.onError((Throwable)cause);
            ChannelCloseUtils.close(this.channel, (Throwable)cause);
        }
    }

    private boolean processPending(SubscriptionImpl target) {
        if (this.pending == null) {
            return false;
        }
        while (true) {
            if (this.requestCount > 0L) {
                Object p = this.pending.poll();
                if (p == null) {
                    return false;
                }
                if ((!(p instanceof TerminalNotification) || !this.emit(target, (TerminalNotification)p)) && !this.emit(target, p)) continue;
                if (this.subscription == null || this.subscription == target) {
                    this.tryPreemptiveChannelCloseInbound();
                    return true;
                }
                target = this.subscription;
                continue;
            }
            if (!(this.pending.peek() instanceof TerminalNotification)) break;
            this.emit(target, (TerminalNotification)this.pending.poll());
            if (this.subscription == null || this.subscription == target) {
                this.tryPreemptiveChannelCloseInbound();
                return true;
            }
            target = this.subscription;
        }
        return false;
    }

    private void tryPreemptiveChannelCloseInbound() {
        TerminalNotification terminal;
        assert (this.pending != null);
        Object top = this.pending.peek();
        if (top instanceof TerminalNotification && (terminal = (TerminalNotification)top).cause() != null) {
            assert (this.fatalError != null);
            this.pending.poll();
            this.closeChannelInbound();
        }
    }

    private boolean emit(SubscriptionImpl target, Object next) {
        assert (this.requestCount > 0L);
        --this.requestCount;
        try {
            Object t = next;
            target.associatedSub.onNext(t);
        }
        catch (Throwable cause) {
            this.emitCatchError(target, cause, true);
            return true;
        }
        return false;
    }

    private void emitCatchError(@Nullable SubscriptionImpl target, Throwable cause, boolean drainPendingToNextTerminal) {
        if (this.pending != null && drainPendingToNextTerminal) {
            Object top;
            while ((top = this.pending.poll()) != null && !(top instanceof TerminalNotification)) {
            }
        }
        if (this.fatalError == null) {
            this.fatalError = cause;
        }
        if (target != null) {
            this.emitError(target, cause);
        } else {
            this.closeChannelOutbound();
            this.closeChannelInbound();
        }
    }

    private boolean emit(SubscriptionImpl target, TerminalNotification terminal) {
        Throwable cause = terminal.cause();
        if (cause == null) {
            this.emitComplete(target);
        } else {
            this.emitError(target, cause);
        }
        return true;
    }

    private void emitComplete(SubscriptionImpl target) {
        this.resetSubscription();
        try {
            target.associatedSub.onComplete();
        }
        catch (Throwable cause) {
            LOGGER.debug("Caught unexpected exception from Subscriber {}, closing channel {}", new Object[]{target.associatedSub, this.channel, cause});
            this.emitCatchError(null, cause, false);
        }
    }

    private void emitError(SubscriptionImpl target, Throwable throwable) {
        this.resetSubscription();
        try {
            target.associatedSub.onError(throwable);
        }
        finally {
            this.closeChannelInbound();
        }
    }

    private void cancel0(SubscriptionImpl forSubscription) {
        if (forSubscription != this.subscription) {
            return;
        }
        LOGGER.debug("{} Cancelling subscription", (Object)this.channel);
        this.resetSubscription();
        this.emitCatchError(null, StacklessClosedChannelException.newInstance(NettyChannelPublisher.class, "cancel"), true);
    }

    private void closeChannelInbound() {
        this.closeHandler.closeChannelInbound(this.channel);
    }

    private void closeChannelOutbound() {
        this.closeHandler.closeChannelOutbound(this.channel);
    }

    private void resetSubscription() {
        this.subscription = null;
        this.requestCount = 0L;
    }

    private void requestChannel() {
        this.requested = true;
        this.channel.read();
    }

    private void addPending(Object p) {
        if (this.pending == null) {
            this.pending = new ArrayDeque<Object>(4);
        }
        this.pending.add(p);
    }

    private boolean shouldBuffer() {
        return this.hasQueuedSignals() || this.requestCount == 0L;
    }

    private boolean hasQueuedSignals() {
        return this.pending != null && !this.pending.isEmpty();
    }

    private void subscribe0(PublisherSource.Subscriber<? super T> subscriber) {
        SubscriptionImpl subscription = this.subscription;
        if (subscription != null) {
            SubscriberUtils.deliverErrorFromSource(subscriber, (Throwable)new DuplicateSubscribeException(subscription.associatedSub, subscriber));
        } else {
            assert (this.requestCount == 0L);
            this.subscription = subscription = new SubscriptionImpl(subscriber);
            subscriber.onSubscribe((PublisherSource.Subscription)subscription);
            if (subscription == this.subscription && !this.processPending(subscription) && this.fatalError != null && !this.hasQueuedSignals()) {
                this.emitError(subscription, this.fatalError);
            }
        }
    }

    private void assertInEventloop() {
        assert (this.eventLoop.inEventLoop()) : "Must be called from the associated eventloop.";
    }

    private final class SubscriptionImpl
    implements PublisherSource.Subscription {
        final PublisherSource.Subscriber<? super T> associatedSub;

        private SubscriptionImpl(PublisherSource.Subscriber<? super T> associatedSub) {
            this.associatedSub = associatedSub;
        }

        public void request(long n) {
            if (NettyChannelPublisher.this.eventLoop.inEventLoop()) {
                NettyChannelPublisher.this.requestN(n, this);
            } else {
                NettyChannelPublisher.this.eventLoop.execute(() -> NettyChannelPublisher.this.requestN(n, this));
            }
        }

        public void cancel() {
            if (NettyChannelPublisher.this.eventLoop.inEventLoop()) {
                NettyChannelPublisher.this.cancel0(this);
            } else {
                NettyChannelPublisher.this.eventLoop.execute(() -> NettyChannelPublisher.this.cancel0(this));
            }
        }
    }
}

