/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.loadbalancer;

import io.servicetalk.client.api.ConnectionFactory;
import io.servicetalk.client.api.LoadBalancedConnection;
import io.servicetalk.client.api.LoadBalancer;
import io.servicetalk.client.api.LoadBalancerFactory;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import io.servicetalk.concurrent.api.DefaultThreadFactory;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Executors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.loadbalancer.NormalizedTimeSourceExecutor;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancer;
import io.servicetalk.loadbalancer.RoundRobinLoadBalancerBuilder;
import io.servicetalk.transport.api.ExecutionStrategy;
import io.servicetalk.utils.internal.DurationUtils;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@Deprecated
public final class RoundRobinLoadBalancerFactory<ResolvedAddress, C extends LoadBalancedConnection>
implements LoadBalancerFactory<ResolvedAddress, C> {
    private static final Duration DEFAULT_HEALTH_CHECK_INTERVAL = Duration.ofSeconds(5L);
    private static final Duration DEFAULT_HEALTH_CHECK_JITTER = Duration.ofSeconds(3L);
    static final Duration DEFAULT_HEALTH_CHECK_RESUBSCRIBE_INTERVAL = Duration.ofSeconds(10L);
    static final int DEFAULT_HEALTH_CHECK_FAILED_CONNECTIONS_THRESHOLD = 5;
    private final String id;
    private final int linearSearchSpace;
    @Nullable
    private final RoundRobinLoadBalancer.HealthCheckConfig healthCheckConfig;

    private RoundRobinLoadBalancerFactory(String id, int linearSearchSpace, @Nullable RoundRobinLoadBalancer.HealthCheckConfig healthCheckConfig) {
        this.id = id;
        this.linearSearchSpace = linearSearchSpace;
        this.healthCheckConfig = healthCheckConfig;
    }

    @Deprecated
    public <T extends C> LoadBalancer<T> newLoadBalancer(String targetResource, Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, T> connectionFactory) {
        return new RoundRobinLoadBalancer<ResolvedAddress, T>(this.id, targetResource, eventPublisher, connectionFactory, this.linearSearchSpace, this.healthCheckConfig);
    }

    public LoadBalancer<C> newLoadBalancer(Publisher<? extends Collection<? extends ServiceDiscovererEvent<ResolvedAddress>>> eventPublisher, ConnectionFactory<ResolvedAddress, C> connectionFactory, String targetResource) {
        return new RoundRobinLoadBalancer<ResolvedAddress, C>(this.id, targetResource, eventPublisher, connectionFactory, this.linearSearchSpace, this.healthCheckConfig);
    }

    public ExecutionStrategy requiredOffloads() {
        return ExecutionStrategy.offloadNone();
    }

    static final class SharedExecutor {
        private static final Executor INSTANCE = new NormalizedTimeSourceExecutor(Executors.from((ExecutorService)new ThreadPoolExecutor(1, 1, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory("round-robin-load-balancer-executor"))));

        private SharedExecutor() {
        }

        static Executor getInstance() {
            return INSTANCE;
        }
    }

    @Deprecated
    public static final class Builder<ResolvedAddress, C extends LoadBalancedConnection>
    implements RoundRobinLoadBalancerBuilder<ResolvedAddress, C> {
        private final String id;
        private int linearSearchSpace = 16;
        @Nullable
        private Executor backgroundExecutor;
        private Duration healthCheckInterval = RoundRobinLoadBalancerFactory.access$000();
        private Duration healthCheckJitter = RoundRobinLoadBalancerFactory.access$100();
        private int healthCheckFailedConnectionsThreshold = 5;
        private long healthCheckResubscribeLowerBound = DEFAULT_HEALTH_CHECK_RESUBSCRIBE_INTERVAL.minus(RoundRobinLoadBalancerFactory.access$100()).toNanos();
        private long healthCheckResubscribeUpperBound = DEFAULT_HEALTH_CHECK_RESUBSCRIBE_INTERVAL.plus(RoundRobinLoadBalancerFactory.access$100()).toNanos();

        @Deprecated
        public Builder() {
            this("undefined");
        }

        Builder(String id) {
            if (id.isEmpty()) {
                throw new IllegalArgumentException("ID can not be empty");
            }
            this.id = id;
        }

        @Override
        public Builder<ResolvedAddress, C> linearSearchSpace(int linearSearchSpace) {
            if (linearSearchSpace < 0) {
                throw new IllegalArgumentException("linearSearchSpace: " + linearSearchSpace + " (expected >=0)");
            }
            this.linearSearchSpace = linearSearchSpace;
            return this;
        }

        @Override
        public Builder<ResolvedAddress, C> backgroundExecutor(Executor backgroundExecutor) {
            this.backgroundExecutor = new NormalizedTimeSourceExecutor(backgroundExecutor);
            return this;
        }

        @Deprecated
        public Builder<ResolvedAddress, C> healthCheckInterval(Duration interval) {
            return this.healthCheckInterval(interval, interval.compareTo(DEFAULT_HEALTH_CHECK_INTERVAL) < 0 ? interval.dividedBy(2L) : DEFAULT_HEALTH_CHECK_JITTER);
        }

        @Override
        public Builder<ResolvedAddress, C> healthCheckInterval(Duration interval, Duration jitter) {
            Builder.validate(interval, jitter);
            this.healthCheckInterval = interval;
            this.healthCheckJitter = jitter;
            return this;
        }

        @Override
        public Builder<ResolvedAddress, C> healthCheckResubscribeInterval(Duration interval, Duration jitter) {
            Builder.validate(interval, jitter);
            this.healthCheckResubscribeLowerBound = interval.minus(jitter).toNanos();
            this.healthCheckResubscribeUpperBound = interval.plus(jitter).toNanos();
            return this;
        }

        private static void validate(Duration interval, Duration jitter) {
            DurationUtils.ensurePositive((Duration)interval, (String)"interval");
            DurationUtils.ensureNonNegative((Duration)jitter, (String)"jitter");
            Duration lowerBound = interval.minus(jitter);
            if (!DurationUtils.isPositive((Duration)lowerBound)) {
                throw new IllegalArgumentException("interval (" + interval + ") minus jitter (" + jitter + ") must be greater than 0, current=" + lowerBound);
            }
            Duration upperBound = interval.plus(jitter);
            if (!DurationUtils.isPositive((Duration)upperBound)) {
                throw new IllegalArgumentException("interval (" + interval + ") plus jitter (" + jitter + ") must not overflow, current=" + upperBound);
            }
        }

        @Override
        public Builder<ResolvedAddress, C> healthCheckFailedConnectionsThreshold(int threshold) {
            if (threshold == 0) {
                throw new IllegalArgumentException("Health check failed connections threshold should not be 0");
            }
            this.healthCheckFailedConnectionsThreshold = threshold;
            return this;
        }

        @Override
        public RoundRobinLoadBalancerFactory<ResolvedAddress, C> build() {
            if (this.healthCheckFailedConnectionsThreshold < 0) {
                return new RoundRobinLoadBalancerFactory(this.id, this.linearSearchSpace, null);
            }
            RoundRobinLoadBalancer.HealthCheckConfig healthCheckConfig = new RoundRobinLoadBalancer.HealthCheckConfig(this.backgroundExecutor == null ? SharedExecutor.getInstance() : this.backgroundExecutor, this.healthCheckInterval, this.healthCheckJitter, this.healthCheckFailedConnectionsThreshold, this.healthCheckResubscribeLowerBound, this.healthCheckResubscribeUpperBound);
            return new RoundRobinLoadBalancerFactory(this.id, this.linearSearchSpace, healthCheckConfig);
        }
    }
}

