/*
 * Decompiled with CFR 0.152.
 */
package net.ripe.ipresource;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import net.ripe.ipresource.Asn;
import net.ripe.ipresource.IpAddress;
import net.ripe.ipresource.IpResource;
import net.ripe.ipresource.IpResourceRange;
import net.ripe.ipresource.Ipv4Address;
import net.ripe.ipresource.Ipv6Address;

public abstract class UniqueIpResource
extends IpResource {
    private static final long serialVersionUID = 1L;

    public abstract BigInteger getValue();

    public abstract int getCommonPrefixLength(UniqueIpResource var1);

    public abstract IpAddress lowerBoundForPrefix(int var1);

    public abstract IpAddress upperBoundForPrefix(int var1);

    @Override
    public final UniqueIpResource getStart() {
        return this;
    }

    @Override
    public final UniqueIpResource getEnd() {
        return this;
    }

    public final UniqueIpResource min(UniqueIpResource other) {
        return this.compareTo(other) < 0 ? this : other;
    }

    public final UniqueIpResource max(UniqueIpResource other) {
        return this.compareTo(other) >= 0 ? this : other;
    }

    protected boolean adjacent(UniqueIpResource other) {
        return this.getType() == other.getType() && this.getValue().subtract(other.getValue()).abs().equals(BigInteger.ONE);
    }

    @Override
    protected int doCompareTo(IpResource obj) {
        if (obj instanceof UniqueIpResource) {
            throw new IllegalStateException("should be overriden by subclass");
        }
        if (obj instanceof IpResourceRange) {
            return this.upTo(this).compareTo(obj);
        }
        throw new IllegalArgumentException("not a valid resource type: " + obj);
    }

    @Override
    public final UniqueIpResource unique() {
        return this;
    }

    public final IpResourceRange upTo(UniqueIpResource end) {
        return IpResourceRange.range(this, end);
    }

    public UniqueIpResource predecessor() {
        return this.getType().fromBigInteger(this.getValue().subtract(BigInteger.ONE));
    }

    public UniqueIpResource successor() {
        return this.getType().fromBigInteger(this.getValue().add(BigInteger.ONE));
    }

    public static UniqueIpResource parse(String s) {
        try {
            return Ipv4Address.parse(s);
        }
        catch (IllegalArgumentException ex4) {
            try {
                try {
                    return Ipv6Address.parse(s);
                }
                catch (IllegalArgumentException ex6) {
                    return Asn.parse(s);
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid IPv4, IPv6 or ASN resource: %s", s));
            }
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField gf = in.readFields();
        try {
            gf.get("type", null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

