/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import java.util.Objects;

public final class SourceAdapters {
    private SourceAdapters() {
    }

    public static <T> PublisherSource<T> toSource(Publisher<T> publisher) {
        if (publisher instanceof PublisherSource) {
            return SourceAdapters.uncheckedCast(publisher);
        }
        return new PublisherToPublisherSource<T>(publisher);
    }

    public static <T> SingleSource<T> toSource(Single<T> single) {
        if (single instanceof SingleSource) {
            return SourceAdapters.uncheckedCast(single);
        }
        return new SingleToSingleSource<T>(single);
    }

    public static CompletableSource toSource(Completable completable) {
        if (completable instanceof CompletableSource) {
            return (CompletableSource)completable;
        }
        return new CompletableToCompletableSource(completable);
    }

    public static <T> Publisher<T> fromSource(PublisherSource<T> source) {
        if (source instanceof Publisher) {
            return SourceAdapters.uncheckedCast(source);
        }
        return new PublisherSourceToPublisher<T>(source);
    }

    public static <T> Single<T> fromSource(SingleSource<T> source) {
        if (source instanceof Single) {
            return SourceAdapters.uncheckedCast(source);
        }
        return new SingleSourceToSingle<T>(source);
    }

    public static Completable fromSource(CompletableSource source) {
        if (source instanceof Completable) {
            return (Completable)source;
        }
        return new CompletableSourceToCompletable(source);
    }

    private static <T> Publisher<T> uncheckedCast(PublisherSource<T> source) {
        return (Publisher)source;
    }

    private static <T> Single<T> uncheckedCast(SingleSource<T> source) {
        return (Single)source;
    }

    private static <T> PublisherSource<T> uncheckedCast(Publisher<T> publisher) {
        return (PublisherSource)publisher;
    }

    private static <T> SingleSource<T> uncheckedCast(Single<T> single) {
        return (SingleSource)single;
    }

    private static final class CompletableSourceToCompletable
    extends Completable
    implements CompletableSource {
        private final CompletableSource source;

        CompletableSourceToCompletable(CompletableSource source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
            this.source.subscribe(subscriber);
        }

        public void subscribe(CompletableSource.Subscriber subscriber) {
            this.source.subscribe(subscriber);
        }
    }

    private static final class SingleSourceToSingle<T>
    extends Single<T>
    implements SingleSource<T> {
        private final SingleSource<T> source;

        SingleSourceToSingle(SingleSource<T> source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        protected void handleSubscribe(SingleSource.Subscriber<? super T> subscriber) {
            this.source.subscribe(subscriber);
        }

        public void subscribe(SingleSource.Subscriber<? super T> subscriber) {
            this.source.subscribe(subscriber);
        }
    }

    private static final class PublisherSourceToPublisher<T>
    extends Publisher<T>
    implements PublisherSource<T> {
        private final PublisherSource<T> source;

        PublisherSourceToPublisher(PublisherSource<T> source) {
            this.source = Objects.requireNonNull(source);
        }

        @Override
        protected void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber) {
            this.source.subscribe(subscriber);
        }

        public void subscribe(PublisherSource.Subscriber<? super T> subscriber) {
            this.source.subscribe(subscriber);
        }
    }

    private static final class CompletableToCompletableSource
    implements CompletableSource {
        private final Completable completable;

        CompletableToCompletableSource(Completable completable) {
            this.completable = Objects.requireNonNull(completable);
        }

        public void subscribe(CompletableSource.Subscriber subscriber) {
            this.completable.subscribeInternal(subscriber);
        }
    }

    private static final class SingleToSingleSource<T>
    implements SingleSource<T> {
        private final Single<T> single;

        SingleToSingleSource(Single<T> single) {
            this.single = Objects.requireNonNull(single);
        }

        public void subscribe(SingleSource.Subscriber<? super T> subscriber) {
            this.single.subscribeInternal(subscriber);
        }
    }

    private static final class PublisherToPublisherSource<T>
    implements PublisherSource<T> {
        private final Publisher<T> publisher;

        PublisherToPublisherSource(Publisher<T> publisher) {
            this.publisher = Objects.requireNonNull(publisher);
        }

        public void subscribe(PublisherSource.Subscriber<? super T> subscriber) {
            this.publisher.subscribeInternal(subscriber);
        }
    }
}

