/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.memory;

import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class Memory<T extends ByteBuffer>
implements Closeable {
    private final int segmentSize;
    private final long segmentShift;
    private final long segmentMask;
    protected final List<T> segments = new ArrayList<T>();

    protected Memory(int segmentSize) {
        if ((segmentSize & -segmentSize) != segmentSize) {
            throw new IllegalArgumentException("The segment size must be a power of 2");
        }
        this.segmentSize = segmentSize;
        this.segmentShift = (long)(Math.log(this.segmentSize) / Math.log(2.0));
        this.segmentMask = (long)this.segmentSize - 1L;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public long segmentShift() {
        return this.segmentShift;
    }

    public long segmentMask() {
        return this.segmentMask;
    }

    public ByteBuffer segment(int index) {
        if (this.segments.size() <= index) {
            return this.allocate(index);
        }
        ByteBuffer segment = (ByteBuffer)this.segments.get(index);
        if (segment == null) {
            return this.allocate(index);
        }
        return segment;
    }

    private synchronized ByteBuffer allocate(int index) {
        while (this.segments.size() <= index) {
            this.segments.add(null);
        }
        ByteBuffer segment = (ByteBuffer)this.segments.get(index);
        if (segment == null) {
            segment = this.allocate(index, this.segmentSize);
            this.segments.set(index, segment);
        }
        return segment;
    }

    public long size() {
        return (long)this.segments.size() * (long)this.segmentSize;
    }

    protected abstract T allocate(int var1, int var2);

    public abstract void clear() throws IOException;
}

