/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type;

import java.nio.ByteBuffer;
import org.apache.baremaps.database.type.DataType;

public class ByteArrayDataType
implements DataType<byte[]> {
    @Override
    public int size(byte[] values) {
        return 4 + values.length * 1;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, byte[] values) {
        buffer.putInt(position, this.size(values));
        buffer.put(position + 4, values, 0, values.length);
    }

    @Override
    public byte[] read(ByteBuffer buffer, int position) {
        int size = buffer.getInt(position);
        byte[] values = new byte[Math.max(size - 4, 0)];
        buffer.get(position + 4, values);
        return values;
    }
}

