/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.database.type.geometry;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.baremaps.database.type.DataType;
import org.apache.baremaps.database.type.geometry.GeometryDataType;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;

public class GeometryCollectionDataType
implements DataType<GeometryCollection> {
    private final GeometryFactory geometryFactory;
    private GeometryDataType geometryDataType;

    public GeometryCollectionDataType() {
        this(new GeometryFactory(), new GeometryDataType());
    }

    public GeometryCollectionDataType(GeometryFactory geometryFactory) {
        this(geometryFactory, new GeometryDataType());
    }

    public GeometryCollectionDataType(GeometryFactory geometryFactory, GeometryDataType geometryDataType) {
        this.geometryFactory = geometryFactory;
        this.geometryDataType = geometryDataType;
    }

    @Override
    public int size(GeometryCollection value) {
        int size = 4;
        for (int i = 0; i < value.getNumGeometries(); ++i) {
            size += this.geometryDataType.size(value.getGeometryN(i));
        }
        return size;
    }

    @Override
    public int size(ByteBuffer buffer, int position) {
        return buffer.getInt(position);
    }

    @Override
    public void write(ByteBuffer buffer, int position, GeometryCollection value) {
        buffer.putInt(position, this.size(value));
        int p = position + 4;
        for (int i = 0; i < value.getNumGeometries(); ++i) {
            Geometry geometry = value.getGeometryN(i);
            this.geometryDataType.write(buffer, p, geometry);
            p += this.geometryDataType.size(buffer, p);
        }
    }

    @Override
    public GeometryCollection read(ByteBuffer buffer, int position) {
        Geometry geometry;
        int size = this.size(buffer, position);
        int limit = position + size;
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (int p = position + 4; p < limit; p += this.geometryDataType.size(geometry)) {
            geometry = this.geometryDataType.read(buffer, p);
            geometries.add(geometry);
        }
        return this.geometryFactory.createGeometryCollection((Geometry[])geometries.toArray(Geometry[]::new));
    }
}

