/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.postgres.copy;

import de.bytefish.pgbulkinsert.pgsql.handlers.BaseValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.BooleanValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ByteArrayValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ByteValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.CollectionValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.DoubleValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.FloatValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.HstoreValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet4AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.Inet6AddressValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.IntegerValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.JsonbValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateTimeValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LocalDateValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.LongValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.ShortValueHandler;
import de.bytefish.pgbulkinsert.pgsql.handlers.StringValueHandler;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import org.apache.baremaps.postgres.copy.GeometryValueHandler;
import org.locationtech.jts.geom.Geometry;
import org.postgresql.copy.PGCopyOutputStream;

public class CopyWriter
implements AutoCloseable {
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final byte IPV4 = 2;
    private static final byte IPV4_MASK = 32;
    private static final byte IPV4_IS_CIDR = 0;
    private static final byte IPV6 = 3;
    private static final int IPV6_MASK = 128;
    private static final byte IPV6_IS_CIDR = 0;
    private static final byte JSONB_VERSION = 1;
    private final DataOutputStream data;

    public CopyWriter(PGCopyOutputStream data) {
        this.data = new DataOutputStream(new BufferedOutputStream((OutputStream)data, 65536));
    }

    public void writeHeader() throws IOException {
        this.data.writeBytes("PGCOPY\n\u00ff\r\n\u0000");
        this.data.writeInt(0);
        this.data.writeInt(0);
    }

    public void writeNull() throws IOException {
        this.data.writeInt(-1);
    }

    public <T> void write(BaseValueHandler<T> handler, T value) throws IOException {
        handler.handle(this.data, value);
    }

    public void startRow(int columns) throws IOException {
        this.data.writeShort(columns);
    }

    public void write(String value) throws IOException {
        new StringValueHandler().handle(this.data, (Object)value);
    }

    public void write(List<String> value) throws IOException {
        new CollectionValueHandler(25, (IValueHandler)new StringValueHandler()).handle(this.data, value);
    }

    public void writeBoolean(Boolean value) throws IOException {
        new BooleanValueHandler().handle(this.data, (Object)value);
    }

    public void writeBooleanList(List<Boolean> value) throws IOException {
        new CollectionValueHandler(16, (IValueHandler)new BooleanValueHandler()).handle(this.data, value);
    }

    public void writeByte(Byte value) throws IOException {
        new ByteValueHandler().handle(this.data, (Object)value);
    }

    public void writeByteArray(byte[] value) throws IOException {
        new ByteArrayValueHandler().handle(this.data, (Object)value);
    }

    public void writeShort(Short value) throws IOException {
        new ShortValueHandler().handle(this.data, (Object)value);
    }

    public void writeShortList(List<Short> value) throws IOException {
        new CollectionValueHandler(21, (IValueHandler)new ShortValueHandler()).handle(this.data, value);
    }

    public void writeInteger(Integer value) throws IOException {
        new IntegerValueHandler().handle(this.data, (Object)value);
    }

    public void writeIntegerList(List<Integer> value) throws IOException {
        new CollectionValueHandler(23, (IValueHandler)new IntegerValueHandler()).handle(this.data, value);
    }

    public void writeLong(Long value) throws IOException {
        new LongValueHandler().handle(this.data, (Object)value);
    }

    public void writeLongList(List<Long> value) throws IOException {
        new CollectionValueHandler(20, (IValueHandler)new LongValueHandler()).handle(this.data, value);
    }

    public void writeFloat(Float value) throws IOException {
        new FloatValueHandler().handle(this.data, (Object)value);
    }

    public void writeFloatList(List<Float> value) throws IOException {
        new CollectionValueHandler(700, (IValueHandler)new FloatValueHandler()).handle(this.data, value);
    }

    public void writeDouble(Double value) throws IOException {
        new DoubleValueHandler().handle(this.data, (Object)value);
    }

    public void writeDoubleArray(List<Double> value) throws IOException {
        new CollectionValueHandler(701, (IValueHandler)new DoubleValueHandler()).handle(this.data, value);
    }

    public void writeLocalDate(LocalDate value) throws IOException {
        new LocalDateValueHandler().handle(this.data, (Object)value);
    }

    public void writeLocalDateTime(LocalDateTime value) throws IOException {
        new LocalDateTimeValueHandler().handle(this.data, (Object)value);
    }

    public void writeInet4Adress(Inet4Address value) throws IOException {
        new Inet4AddressValueHandler().handle(this.data, (Object)value);
    }

    public void writeInet6Adress(Inet6Address value) throws IOException {
        new Inet6AddressValueHandler().handle(this.data, (Object)value);
    }

    public void writeHstore(Map<String, String> value) throws IOException {
        new HstoreValueHandler().handle(this.data, value);
    }

    public void writeJsonb(String value) throws IOException {
        new JsonbValueHandler().handle(this.data, (Object)value);
    }

    public void writeGeometry(Geometry value) throws IOException {
        new GeometryValueHandler().handle(this.data, value);
    }

    @Override
    public void close() throws IOException {
        this.data.writeShort(-1);
        this.data.flush();
        this.data.close();
    }
}

